rule win_bluehaze_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bluehaze."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bluehaze"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85ff 7405 8b4dec 890f 83c704 897dd8 3b5604 }
            // n = 7, score = 100
            //   85ff                 | test                edi, edi
            //   7405                 | je                  7
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   890f                 | mov                 dword ptr [edi], ecx
            //   83c704               | add                 edi, 4
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi
            //   3b5604               | cmp                 edx, dword ptr [esi + 4]

        $sequence_1 = { 894704 8b4804 8901 837dcc10 c745fcffffffff 720c }
            // n = 6, score = 100
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   837dcc10             | cmp                 dword ptr [ebp - 0x34], 0x10
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   720c                 | jb                  0xe

        $sequence_2 = { 51 c745fc00000000 e8???????? 83c408 837de810 720c 8b55d4 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   720c                 | jb                  0xe
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]

        $sequence_3 = { c706???????? 8bc6 5e 8be5 5d c3 8d45fc }
            // n = 7, score = 100
            //   c706????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_4 = { 33d2 eb02 8b10 8b4518 85c0 740c }
            // n = 6, score = 100
            //   33d2                 | xor                 edx, edx
            //   eb02                 | jmp                 4
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe

        $sequence_5 = { 03ce 51 8b4b6c 57 51 ff15???????? }
            // n = 6, score = 100
            //   03ce                 | add                 ecx, esi
            //   51                   | push                ecx
            //   8b4b6c               | mov                 ecx, dword ptr [ebx + 0x6c]
            //   57                   | push                edi
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_6 = { c706???????? e8???????? 6a30 c745fc00000000 c7462000000000 e8???????? 83c404 }
            // n = 7, score = 100
            //   c706????????         |                     
            //   e8????????           |                     
            //   6a30                 | push                0x30
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c7462000000000       | mov                 dword ptr [esi + 0x20], 0
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_7 = { 53 8d9564feffff 52 8d8dd4feffff e8???????? 8b7010 838d20feffff01 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8d9564feffff         | lea                 edx, [ebp - 0x19c]
            //   52                   | push                edx
            //   8d8dd4feffff         | lea                 ecx, [ebp - 0x12c]
            //   e8????????           |                     
            //   8b7010               | mov                 esi, dword ptr [eax + 0x10]
            //   838d20feffff01       | or                  dword ptr [ebp - 0x1e0], 1

        $sequence_8 = { c747140f000000 895f10 881f 833e10 7315 8b56fc }
            // n = 6, score = 100
            //   c747140f000000       | mov                 dword ptr [edi + 0x14], 0xf
            //   895f10               | mov                 dword ptr [edi + 0x10], ebx
            //   881f                 | mov                 byte ptr [edi], bl
            //   833e10               | cmp                 dword ptr [esi], 0x10
            //   7315                 | jae                 0x17
            //   8b56fc               | mov                 edx, dword ptr [esi - 4]

        $sequence_9 = { e8???????? 83c404 c785ccfeffff0f000000 899dc8feffff 889db8feffff c645fc03 39b578feffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c785ccfeffff0f000000     | mov    dword ptr [ebp - 0x134], 0xf
            //   899dc8feffff         | mov                 dword ptr [ebp - 0x138], ebx
            //   889db8feffff         | mov                 byte ptr [ebp - 0x148], bl
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   39b578feffff         | cmp                 dword ptr [ebp - 0x188], esi

    condition:
        7 of them and filesize < 424960
}