rule win_boatlaunch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.boatlaunch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.boatlaunch"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7430c00000000 c7431000000000 c7431400000000 8d45f0 50 8d45d8 }
            // n = 6, score = 100
            //   c7430c00000000       | mov                 edi, esi
            //   c7431000000000       | mov                 ebx, 0x40
            //   c7431400000000       | dec                 eax
            //   8d45f0               | mov                 eax, 1
            //   50                   | dec                 eax
            //   8d45d8               | lea                 esp, [ebp]

        $sequence_1 = { 8345e802 4b 85db 75af eb05 e9???????? }
            // n = 6, score = 100
            //   8345e802             | mov                 eax, dword ptr [ebp - 4]
            //   4b                   | pop                 edi
            //   85db                 | lea                 eax, [ebp - 0x1120]
            //   75af                 | push                eax
            //   eb05                 | add                 esp, 4
            //   e9????????           |                     

        $sequence_2 = { 0f84b1000000 8b4878 85c9 0f84a6000000 894dec 03cf 894df0 }
            // n = 7, score = 100
            //   0f84b1000000         | lea                 eax, [ebp - 0x24]
            //   8b4878               | push                eax
            //   85c9                 | push                0x1f0fff
            //   0f84a6000000         | mov                 dword ptr [ebx + 0xc], 0
            //   894dec               | mov                 dword ptr [ebx + 0x10], 0
            //   03cf                 | mov                 dword ptr [ebx + 0x14], 0
            //   894df0               | lea                 eax, [ebp - 0xc]

        $sequence_3 = { 7502 48ab 488bfe ffcb 85db }
            // n = 5, score = 100
            //   7502                 | inc                 ecx
            //   48ab                 | push                ecx
            //   488bfe               | inc                 ecx
            //   ffcb                 | push                edx
            //   85db                 | inc                 ecx

        $sequence_4 = { 488b4dd0 e8???????? 488b45d8 488d6528 415b }
            // n = 5, score = 100
            //   488b4dd0             | dec                 eax
            //   e8????????           |                     
            //   488b45d8             | mov                 edi, esi
            //   488d6528             | dec                 ebx
            //   415b                 | test                ebx, ebx

        $sequence_5 = { 8b45e4 03701c 2b75ec 0375e4 ad 85c0 7407 }
            // n = 7, score = 100
            //   8b45e4               | mov                 dword ptr [ebx + 0x14], 0
            //   03701c               | lea                 eax, [ebp - 0x10]
            //   2b75ec               | push                eax
            //   0375e4               | lea                 eax, [ebp - 0x28]
            //   ad                   | mov                 dword ptr [ebx + 0x14], 0
            //   85c0                 | lea                 eax, [ebp - 0xc]
            //   7407                 | push                eax

        $sequence_6 = { 448b45fc e8???????? 48894500 48c7c105000000 }
            // n = 4, score = 100
            //   448b45fc             | dec                 eax
            //   e8????????           |                     
            //   48894500             | push                ebp
            //   48c7c105000000       | inc                 esp

        $sequence_7 = { 488d6c2430 48c745f800000000 488d35901e0000 488bfe bb40000000 }
            // n = 5, score = 100
            //   488d6c2430           | push                ebx
            //   48c745f800000000     | dec                 eax
            //   488d35901e0000       | sub                 esp, 0x1178
            //   488bfe               | dec                 eax
            //   bb40000000           | lea                 ebp, [esp + 0x80]

        $sequence_8 = { 488905???????? 48c7c001000000 488d6500 5d }
            // n = 4, score = 100
            //   488905????????       |                     
            //   48c7c001000000       | dec                 eax
            //   488d6500             | mov                 dword ptr [ebp - 0x18], 0
            //   5d                   | jne                 4

        $sequence_9 = { c745f800000000 8d5ddc c70318000000 c7430400000000 }
            // n = 4, score = 100
            //   c745f800000000       | push                dword ptr [ebp - 8]
            //   8d5ddc               | cmp                 ebx, 0x102
            //   c70318000000         | jne                 0xf
            //   c7430400000000       | mov                 dword ptr [ebp - 4], 1

        $sequence_10 = { 8d85e0eeffff 50 e8???????? 83c404 53 }
            // n = 5, score = 100
            //   8d85e0eeffff         | mov                 eax, dword ptr [ebp - 0x30]
            //   50                   | movzx               esi, word ptr [eax]
            //   e8????????           |                     
            //   83c404               | shl                 esi, 2
            //   53                   | dec                 eax

        $sequence_11 = { 5a 59 5b 5d c3 48894c2408 4855 }
            // n = 7, score = 100
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   48894c2408           | dec                 eax
            //   4855                 | mov                 dword ptr [esp + 8], ecx

        $sequence_12 = { ff75f8 e8???????? 81fb02010000 7507 c745fc01000000 8b45fc 5f }
            // n = 7, score = 100
            //   ff75f8               | lea                 esp, [ebp + 0x28]
            //   e8????????           |                     
            //   81fb02010000         | inc                 ecx
            //   7507                 | pop                 ebx
            //   c745fc01000000       | cmp                 eax, dword ptr [ebp + 0x1160]
            //   8b45fc               | jne                 0x28
            //   5f                   | dec                 eax

        $sequence_13 = { c7431400000000 8d45f4 50 8d45dc 50 68ff0f1f00 }
            // n = 6, score = 100
            //   c7431400000000       | pop                 ebp
            //   8d45f4               | dec                 eax
            //   50                   | mov                 ecx, 0x64
            //   8d45dc               | dec                 eax
            //   50                   | lea                 esp, [ebp]
            //   68ff0f1f00           | dec                 eax

        $sequence_14 = { 48c7c164000000 e8???????? e9???????? 488d6500 }
            // n = 4, score = 100
            //   48c7c164000000       | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     
            //   488d6500             | stosd               dword ptr es:[edi], eax

        $sequence_15 = { 4150 4151 4152 4153 4881ec78110000 488dac2480000000 48c745e800000000 }
            // n = 7, score = 100
            //   4150                 | mov                 eax, dword ptr [ebp - 4]
            //   4151                 | dec                 eax
            //   4152                 | mov                 dword ptr [ebp], eax
            //   4153                 | dec                 eax
            //   4881ec78110000       | mov                 ecx, 5
            //   488dac2480000000     | inc                 ecx
            //   48c745e800000000     | push                eax

    condition:
        7 of them and filesize < 33792
}