rule win_bolek_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bolek."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bolek"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f76b10 0fa4ce01 03c9 03c8 8b4340 13f2 f72f }
            // n = 7, score = 600
            //   f76b10               | imul                dword ptr [ebx + 0x10]
            //   0fa4ce01             | shld                esi, ecx, 1
            //   03c9                 | add                 ecx, ecx
            //   03c8                 | add                 ecx, eax
            //   8b4340               | mov                 eax, dword ptr [ebx + 0x40]
            //   13f2                 | adc                 esi, edx
            //   f72f                 | imul                dword ptr [edi]

        $sequence_1 = { 8bec 83ec18 53 56 57 33c0 8bfa }
            // n = 7, score = 600
            //   8bec                 | mov                 ebp, esp
            //   83ec18               | sub                 esp, 0x18
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   8bfa                 | mov                 edi, edx

        $sequence_2 = { 8b55f8 391401 7416 41 3bce 72f6 33c0 }
            // n = 7, score = 600
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   391401               | cmp                 dword ptr [ecx + eax], edx
            //   7416                 | je                  0x18
            //   41                   | inc                 ecx
            //   3bce                 | cmp                 ecx, esi
            //   72f6                 | jb                  0xfffffff8
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 0f84a5000000 8b45f4 8b7028 83c60c 0375e0 e9???????? 8d45e8 }
            // n = 7, score = 600
            //   0f84a5000000         | je                  0xab
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b7028               | mov                 esi, dword ptr [eax + 0x28]
            //   83c60c               | add                 esi, 0xc
            //   0375e0               | add                 esi, dword ptr [ebp - 0x20]
            //   e9????????           |                     
            //   8d45e8               | lea                 eax, [ebp - 0x18]

        $sequence_4 = { c606ff 3dff000000 751a 6a05 6a06 5a 32c9 }
            // n = 7, score = 600
            //   c606ff               | mov                 byte ptr [esi], 0xff
            //   3dff000000           | cmp                 eax, 0xff
            //   751a                 | jne                 0x1c
            //   6a05                 | push                5
            //   6a06                 | push                6
            //   5a                   | pop                 edx
            //   32c9                 | xor                 cl, cl

        $sequence_5 = { ffb42450080000 50 8d84244c060000 50 e8???????? 8d442444 55 }
            // n = 7, score = 600
            //   ffb42450080000       | push                dword ptr [esp + 0x850]
            //   50                   | push                eax
            //   8d84244c060000       | lea                 eax, [esp + 0x64c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d442444             | lea                 eax, [esp + 0x44]
            //   55                   | push                ebp

        $sequence_6 = { 899c248c000000 89b42490000000 e8???????? 83c440 85c0 0f85e7fdffff 53 }
            // n = 7, score = 600
            //   899c248c000000       | mov                 dword ptr [esp + 0x8c], ebx
            //   89b42490000000       | mov                 dword ptr [esp + 0x90], esi
            //   e8????????           |                     
            //   83c440               | add                 esp, 0x40
            //   85c0                 | test                eax, eax
            //   0f85e7fdffff         | jne                 0xfffffded
            //   53                   | push                ebx

        $sequence_7 = { ff742444 8d442434 50 e8???????? 6a10 8d44243c 55 }
            // n = 7, score = 600
            //   ff742444             | push                dword ptr [esp + 0x44]
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a10                 | push                0x10
            //   8d44243c             | lea                 eax, [esp + 0x3c]
            //   55                   | push                ebp

        $sequence_8 = { ff742438 ff742438 56 e8???????? 69ce0d661900 83c40c 8bf8 }
            // n = 7, score = 600
            //   ff742438             | push                dword ptr [esp + 0x38]
            //   ff742438             | push                dword ptr [esp + 0x38]
            //   56                   | push                esi
            //   e8????????           |                     
            //   69ce0d661900         | imul                ecx, esi, 0x19660d
            //   83c40c               | add                 esp, 0xc
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { 894dec c745f440000000 894df8 894dfc ff15???????? 8be5 5d }
            // n = 7, score = 600
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   c745f440000000       | mov                 dword ptr [ebp - 0xc], 0x40
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   ff15????????         |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 892928
}