rule win_bootwreck_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bootwreck."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bootwreck"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 9e 3ec9 307dd6 14cc 7466 d59d }
            // n = 6, score = 100
            //   9e                   | sahf                
            //   3ec9                 | leave               
            //   307dd6               | xor                 byte ptr [ebp - 0x2a], bh
            //   14cc                 | adc                 al, 0xcc
            //   7466                 | je                  0x68
            //   d59d                 | aad                 0x9d

        $sequence_1 = { c60424de 57 9c 875c242c ff742404 54 9c }
            // n = 7, score = 100
            //   c60424de             | mov                 byte ptr [esp], 0xde
            //   57                   | push                edi
            //   9c                   | pushfd              
            //   875c242c             | xchg                dword ptr [esp + 0x2c], ebx
            //   ff742404             | push                dword ptr [esp + 4]
            //   54                   | push                esp
            //   9c                   | pushfd              

        $sequence_2 = { fd 7919 87c1 0e d9574e 6d 7db2 }
            // n = 7, score = 100
            //   fd                   | std                 
            //   7919                 | jns                 0x1b
            //   87c1                 | xchg                ecx, eax
            //   0e                   | push                cs
            //   d9574e               | fst                 dword ptr [edi + 0x4e]
            //   6d                   | insd                dword ptr es:[edi], dx
            //   7db2                 | jge                 0xffffffb4

        $sequence_3 = { 8b8020334500 c60424ef 60 8d8090b42a7f 8d642434 0f8f702c0000 687b1f6def }
            // n = 7, score = 100
            //   8b8020334500         | mov                 eax, dword ptr [eax + 0x453320]
            //   c60424ef             | mov                 byte ptr [esp], 0xef
            //   60                   | pushal              
            //   8d8090b42a7f         | lea                 eax, [eax + 0x7f2ab490]
            //   8d642434             | lea                 esp, [esp + 0x34]
            //   0f8f702c0000         | jg                  0x2c76
            //   687b1f6def           | push                0xef6d1f7b

        $sequence_4 = { 660fb6db 89f3 660fbef1 5e 660fce 8b742440 88442404 }
            // n = 7, score = 100
            //   660fb6db             | movzx               bx, bl
            //   89f3                 | mov                 ebx, esi
            //   660fbef1             | movsx               si, cl
            //   5e                   | pop                 esi
            //   660fce               | bswap               si
            //   8b742440             | mov                 esi, dword ptr [esp + 0x40]
            //   88442404             | mov                 byte ptr [esp + 4], al

        $sequence_5 = { 70e8 32ff 46 33e2 41 2eb910b0f8ab 828dc6785b1254 }
            // n = 7, score = 100
            //   70e8                 | jo                  0xffffffea
            //   32ff                 | xor                 bh, bh
            //   46                   | inc                 esi
            //   33e2                 | xor                 esp, edx
            //   41                   | inc                 ecx
            //   2eb910b0f8ab         | mov                 ecx, 0xabf8b010
            //   828dc6785b1254       | or                  byte ptr [ebp + 0x125b78c6], 0x54

        $sequence_6 = { e8???????? f6d2 8b5620 60 9c ff742404 89542424 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   f6d2                 | not                 dl
            //   8b5620               | mov                 edx, dword ptr [esi + 0x20]
            //   60                   | pushal              
            //   9c                   | pushfd              
            //   ff742404             | push                dword ptr [esp + 4]
            //   89542424             | mov                 dword ptr [esp + 0x24], edx

        $sequence_7 = { 60 e7c6 45 14bb aa 11fe 1d0a3b6a57 }
            // n = 7, score = 100
            //   60                   | pushal              
            //   e7c6                 | out                 0xc6, eax
            //   45                   | inc                 ebp
            //   14bb                 | adc                 al, 0xbb
            //   aa                   | stosb               byte ptr es:[edi], al
            //   11fe                 | adc                 esi, edi
            //   1d0a3b6a57           | sbb                 eax, 0x576a3b0a

        $sequence_8 = { b6d1 0206 82535e09 3909 a6 ae 57 }
            // n = 7, score = 100
            //   b6d1                 | mov                 dh, 0xd1
            //   0206                 | add                 al, byte ptr [esi]
            //   82535e09             | adc                 byte ptr [ebx + 0x5e], 9
            //   3909                 | cmp                 dword ptr [ecx], ecx
            //   a6                   | cmpsb               byte ptr [esi], byte ptr es:[edi]
            //   ae                   | scasb               al, byte ptr es:[edi]
            //   57                   | push                edi

        $sequence_9 = { 660fb6c9 660bf9 0fb7cf 8b7d10 894d0c 2acb 32c8 }
            // n = 7, score = 100
            //   660fb6c9             | movzx               cx, cl
            //   660bf9               | or                  di, cx
            //   0fb7cf               | movzx               ecx, di
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   894d0c               | mov                 dword ptr [ebp + 0xc], ecx
            //   2acb                 | sub                 cl, bl
            //   32c8                 | xor                 cl, al

    condition:
        7 of them and filesize < 10821632
}