rule win_borr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.borr"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 98 07 64698dd274ce015b3d8c47 04f0 c50c8c }
            // n = 5, score = 100
            //   98                   | cwde                
            //   07                   | pop                 es
            //   64698dd274ce015b3d8c47     | imul    ecx, dword ptr fs:[ebp + 0x1ce74d2], 0x478c3d5b
            //   04f0                 | add                 al, 0xf0
            //   c50c8c               | lds                 ecx, ptr [esp + ecx*4]

        $sequence_1 = { c1700afd bd59be600d 73f1 7085 }
            // n = 4, score = 100
            //   c1700afd             | sal                 dword ptr [eax + 0xa], 0xfd
            //   bd59be600d           | mov                 ebp, 0xd60be59
            //   73f1                 | jae                 0xfffffff3
            //   7085                 | jo                  0xffffff87

        $sequence_2 = { 8d33 27 93 57 41 de20 5e }
            // n = 7, score = 100
            //   8d33                 | lea                 esi, [ebx]
            //   27                   | daa                 
            //   93                   | xchg                eax, ebx
            //   57                   | push                edi
            //   41                   | inc                 ecx
            //   de20                 | fisub               word ptr [eax]
            //   5e                   | pop                 esi

        $sequence_3 = { ae 6d 5b d7 fd 80e238 }
            // n = 6, score = 100
            //   ae                   | scasb               al, byte ptr es:[edi]
            //   6d                   | insd                dword ptr es:[edi], dx
            //   5b                   | pop                 ebx
            //   d7                   | xlatb               
            //   fd                   | std                 
            //   80e238               | and                 dl, 0x38

        $sequence_4 = { 047e 54 e5cf 3d537dbec7 }
            // n = 4, score = 100
            //   047e                 | add                 al, 0x7e
            //   54                   | push                esp
            //   e5cf                 | in                  eax, 0xcf
            //   3d537dbec7           | cmp                 eax, 0xc7be7d53

        $sequence_5 = { e68b 663115???????? 657650 9a2a2c6a698e8e af 7c88 c1700afd }
            // n = 7, score = 100
            //   e68b                 | out                 0x8b, al
            //   663115????????       |                     
            //   657650               | jbe                 0x53
            //   9a2a2c6a698e8e       | lcall               0x8e8e:0x696a2c2a
            //   af                   | scasd               eax, dword ptr es:[edi]
            //   7c88                 | jl                  0xffffff8a
            //   c1700afd             | sal                 dword ptr [eax + 0xa], 0xfd

        $sequence_6 = { 047e 54 e5cf 3d537dbec7 001cf2 8be7 }
            // n = 6, score = 100
            //   047e                 | add                 al, 0x7e
            //   54                   | push                esp
            //   e5cf                 | in                  eax, 0xcf
            //   3d537dbec7           | cmp                 eax, 0xc7be7d53
            //   001cf2               | add                 byte ptr [edx + esi*8], bl
            //   8be7                 | mov                 esp, edi

        $sequence_7 = { 35d9fe2fd2 e12e 03b017471d3d ee 69a8cfadc967b91e8d27 }
            // n = 5, score = 100
            //   35d9fe2fd2           | xor                 eax, 0xd22ffed9
            //   e12e                 | loope               0x30
            //   03b017471d3d         | add                 esi, dword ptr [eax + 0x3d1d4717]
            //   ee                   | out                 dx, al
            //   69a8cfadc967b91e8d27     | imul    ebp, dword ptr [eax + 0x67c9adcf], 0x278d1eb9

        $sequence_8 = { e4a9 7876 d559 bad4bf4d6f 93 aa 3b7f5e }
            // n = 7, score = 100
            //   e4a9                 | in                  al, 0xa9
            //   7876                 | js                  0x78
            //   d559                 | aad                 0x59
            //   bad4bf4d6f           | mov                 edx, 0x6f4dbfd4
            //   93                   | xchg                eax, ebx
            //   aa                   | stosb               byte ptr es:[edi], al
            //   3b7f5e               | cmp                 edi, dword ptr [edi + 0x5e]

        $sequence_9 = { 93 aa 3b7f5e fa }
            // n = 4, score = 100
            //   93                   | xchg                eax, ebx
            //   aa                   | stosb               byte ptr es:[edi], al
            //   3b7f5e               | cmp                 edi, dword ptr [edi + 0x5e]
            //   fa                   | cli                 

    condition:
        7 of them and filesize < 1131520
}