rule win_bottomloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bottomloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bottomloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 488d3537d60700 488975c8 48c745c00e000000 488d4dc0 e8???????? 488d051bd60700 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d3537d60700       | dec                 eax
            //   488975c8             | mov                 eax, dword ptr [ecx + eax*8]
            //   48c745c00e000000     | mov                 ecx, 0xa28
            //   488d4dc0             | dec                 eax
            //   e8????????           |                     
            //   488d051bd60700       | arpl                word ptr [eax + ecx], ax

        $sequence_1 = { e8???????? 4889c6 488d0579400600 488945c8 48c745c016000000 488d55c0 48899578feffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889c6               | lea                 edx, [0x42f81]
            //   488d0579400600       | dec                 eax
            //   488945c8             | mov                 ebx, dword ptr [0x58]
            //   48c745c016000000     | dec                 eax
            //   488d55c0             | mov                 esi, dword ptr [ebx + eax*8]
            //   48899578feffff       | mov                 ecx, 0xb40

        $sequence_2 = { 48897de8 e8???????? 4889c7 4885ff 746f 488d0ddcda0700 e8???????? }
            // n = 7, score = 100
            //   48897de8             | dec                 ebp
            //   e8????????           |                     
            //   4889c7               | mov                 eax, ecx
            //   4885ff               | mov                 edx, 0xdb
            //   746f                 | dec                 eax
            //   488d0ddcda0700       | lea                 ecx, [0x6654c]
            //   e8????????           |                     

        $sequence_3 = { 4889bdd8fdffff 8b05???????? 65488b0c2558000000 488b14c1 bbf0090000 4c8b441a08 4c0b041a }
            // n = 7, score = 100
            //   4889bdd8fdffff       | mov                 eax, eax
            //   8b05????????         |                     
            //   65488b0c2558000000     | mov    esi, 0x1000
            //   488b14c1             | dec                 eax
            //   bbf0090000           | cmp                 eax, esi
            //   4c8b441a08           | mov                 ecx, 0xb60
            //   4c0b041a             | mov                 byte ptr [edx + ecx], 1

        $sequence_4 = { 488975f8 488d55f0 488d8d70ffffff e8???????? 488d8d70ffffff e8???????? 488b9d60ffffff }
            // n = 7, score = 100
            //   488975f8             | dec                 eax
            //   488d55f0             | lea                 edx, [0xa581d]
            //   488d8d70ffffff       | dec                 eax
            //   e8????????           |                     
            //   488d8d70ffffff       | mov                 dword ptr [ebp - 0x18], edx
            //   e8????????           |                     
            //   488b9d60ffffff       | je                  0x91c

        $sequence_5 = { ba43010000 488d0d57dc0700 e8???????? 4d8b542408 410fb63412 eb05 beff000000 }
            // n = 7, score = 100
            //   ba43010000           | dec                 eax
            //   488d0d57dc0700       | lea                 esi, [0x87531]
            //   e8????????           |                     
            //   4d8b542408           | dec                 eax
            //   410fb63412           | lea                 edi, [ebp - 0x28]
            //   eb05                 | dec                 eax
            //   beff000000           | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_6 = { 488d0dc5800b00 4883ec20 e8???????? 4883c420 48898550ffffff 48899558ffffff 4c8b8550ffffff }
            // n = 7, score = 100
            //   488d0dc5800b00       | sub                 esp, 0x20
            //   4883ec20             | inc                 ecx
            //   e8????????           |                     
            //   4883c420             | push                eax
            //   48898550ffffff       | dec                 esp
            //   48899558ffffff       | mov                 ecx, esi
            //   4c8b8550ffffff       | inc                 ebp

        $sequence_7 = { c3 48895518 488d058b140b00 488945f8 48c745f027000000 488d55f0 8bce }
            // n = 7, score = 100
            //   c3                   | dec                 eax
            //   48895518             | mov                 dword ptr [ebp - 0xb8], edx
            //   488d058b140b00       | mov                 edx, 0x10
            //   488945f8             | dec                 eax
            //   48c745f027000000     | mov                 dword ptr [ebp - 0xf0], eax
            //   488d55f0             | dec                 eax
            //   8bce                 | mov                 dword ptr [ebp - 0xe8], edx

        $sequence_8 = { 7442 4883fa02 7472 e9???????? 4d8bc4 488d5520 488d8db0feffff }
            // n = 7, score = 100
            //   7442                 | mov                 eax, dword ptr [eax]
            //   4883fa02             | dec                 eax
            //   7472                 | mov                 dword ptr [ebp + 0x18], edx
            //   e9????????           |                     
            //   4d8bc4               | dec                 esp
            //   488d5520             | mov                 eax, dword ptr [ebp + 0x18]
            //   488d8db0feffff       | dec                 eax

        $sequence_9 = { 4531c0 ba86100000 488d0db8fd0500 e8???????? 4a8d0c0b 488b55f8 e8???????? }
            // n = 7, score = 100
            //   4531c0               | dec                 esp
            //   ba86100000           | mov                 dword ptr [ebp - 0xd0], eax
            //   488d0db8fd0500       | dec                 esp
            //   e8????????           |                     
            //   4a8d0c0b             | lea                 eax, [esi + 1]
            //   488b55f8             | dec                 ebp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1955840
}