rule win_boxcaon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.boxcaon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.boxcaon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 897e14 897e70 c686c800000043 c6864b01000043 c7466890b54000 6a0d e8???????? }
            // n = 7, score = 100
            //   897e14               | mov                 dword ptr [esi + 0x14], edi
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c7466890b54000       | mov                 dword ptr [esi + 0x68], 0x40b590
            //   6a0d                 | push                0xd
            //   e8????????           |                     

        $sequence_1 = { 8bd3 66899424e0000000 5a 6a50 66899424e2000000 8bd1 66899424e4000000 }
            // n = 7, score = 100
            //   8bd3                 | mov                 edx, ebx
            //   66899424e0000000     | mov                 word ptr [esp + 0xe0], dx
            //   5a                   | pop                 edx
            //   6a50                 | push                0x50
            //   66899424e2000000     | mov                 word ptr [esp + 0xe2], dx
            //   8bd1                 | mov                 edx, ecx
            //   66899424e4000000     | mov                 word ptr [esp + 0xe4], dx

        $sequence_2 = { 8888b8b84000 40 ebe6 ff35???????? }
            // n = 4, score = 100
            //   8888b8b84000         | mov                 byte ptr [eax + 0x40b8b8], cl
            //   40                   | inc                 eax
            //   ebe6                 | jmp                 0xffffffe8
            //   ff35????????         |                     

        $sequence_3 = { 8bec 33c0 8b4d08 3b0cc5408a4000 740a }
            // n = 5, score = 100
            //   8bec                 | mov                 ebp, esp
            //   33c0                 | xor                 eax, eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   3b0cc5408a4000       | cmp                 ecx, dword ptr [eax*8 + 0x408a40]
            //   740a                 | je                  0xc

        $sequence_4 = { c78424980000003c000000 ff15???????? 56 33ff }
            // n = 4, score = 100
            //   c78424980000003c000000     | mov    dword ptr [esp + 0x98], 0x3c
            //   ff15????????         |                     
            //   56                   | push                esi
            //   33ff                 | xor                 edi, edi

        $sequence_5 = { e8???????? 84c0 741a 8d4c2410 8d8424d8020000 2bc1 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   741a                 | je                  0x1c
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   8d8424d8020000       | lea                 eax, [esp + 0x2d8]
            //   2bc1                 | sub                 eax, ecx

        $sequence_6 = { 89bc24ac000000 89b424b4000000 c78424980000003c000000 ff15???????? }
            // n = 4, score = 100
            //   89bc24ac000000       | mov                 dword ptr [esp + 0xac], edi
            //   89b424b4000000       | mov                 dword ptr [esp + 0xb4], esi
            //   c78424980000003c000000     | mov    dword ptr [esp + 0x98], 0x3c
            //   ff15????????         |                     

        $sequence_7 = { 33c9 66890c06 68???????? 8d442414 50 e8???????? }
            // n = 6, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   66890c06             | mov                 word ptr [esi + eax], cx
            //   68????????           |                     
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 0020 1f 40 00441f40 0023 d18a0688078a 46 }
            // n = 7, score = 100
            //   0020                 | add                 byte ptr [eax], ah
            //   1f                   | pop                 ds
            //   40                   | inc                 eax
            //   00441f40             | add                 byte ptr [edi + ebx + 0x40], al
            //   0023                 | add                 byte ptr [ebx], ah
            //   d18a0688078a         | ror                 dword ptr [edx - 0x75f877fa], 1
            //   46                   | inc                 esi

        $sequence_9 = { 33c0 c7461407000000 668906 8b4508 8b5810 57 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   c7461407000000       | mov                 dword ptr [esi + 0x14], 7
            //   668906               | mov                 word ptr [esi], ax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b5810               | mov                 ebx, dword ptr [eax + 0x10]
            //   57                   | push                edi

    condition:
        7 of them and filesize < 256000
}