rule win_brambul_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.brambul."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.brambul"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4e03 2bee 8a01 8ad8 80e30f c0e804 }
            // n = 6, score = 100
            //   8d4e03               | lea                 ecx, [esi + 3]
            //   2bee                 | sub                 ebp, esi
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   8ad8                 | mov                 bl, al
            //   80e30f               | and                 bl, 0xf
            //   c0e804               | shr                 al, 4

        $sequence_1 = { a3???????? 68???????? 68???????? e8???????? 83c408 50 }
            // n = 6, score = 100
            //   a3????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   50                   | push                eax

        $sequence_2 = { 8d8c2438020000 51 ff15???????? 8bac2428090000 83c9ff 8bfd }
            // n = 6, score = 100
            //   8d8c2438020000       | lea                 ecx, [esp + 0x238]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8bac2428090000       | mov                 ebp, dword ptr [esp + 0x928]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   8bfd                 | mov                 edi, ebp

        $sequence_3 = { 33c0 8d94240c010000 f2ae f7d1 2bf9 6a00 8bc1 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   8d94240c010000       | lea                 edx, [esp + 0x10c]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   6a00                 | push                0
            //   8bc1                 | mov                 eax, ecx

        $sequence_4 = { 8b4c241c 40 3bc1 89442418 0f8cfefeffff 8b442414 }
            // n = 6, score = 100
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   40                   | inc                 eax
            //   3bc1                 | cmp                 eax, ecx
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   0f8cfefeffff         | jl                  0xffffff04
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]

        $sequence_5 = { 83c40c 8b5514 833a00 0f84db000000 837decfe 0f8ed1000000 c745e401000000 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   833a00               | cmp                 dword ptr [edx], 0
            //   0f84db000000         | je                  0xe1
            //   837decfe             | cmp                 dword ptr [ebp - 0x14], -2
            //   0f8ed1000000         | jle                 0xd7
            //   c745e401000000       | mov                 dword ptr [ebp - 0x1c], 1

        $sequence_6 = { 8985a849ffff 8985c05dffff 8985c45dffff 8945f8 895df0 }
            // n = 5, score = 100
            //   8985a849ffff         | mov                 dword ptr [ebp - 0xb658], eax
            //   8985c05dffff         | mov                 dword ptr [ebp - 0xa240], eax
            //   8985c45dffff         | mov                 dword ptr [ebp - 0xa23c], eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx

        $sequence_7 = { 8b4002 8985b049ffff c785ac49ffff02000000 e9???????? f6c140 0f8428010000 f6c120 }
            // n = 7, score = 100
            //   8b4002               | mov                 eax, dword ptr [eax + 2]
            //   8985b049ffff         | mov                 dword ptr [ebp - 0xb650], eax
            //   c785ac49ffff02000000     | mov    dword ptr [ebp - 0xb654], 2
            //   e9????????           |                     
            //   f6c140               | test                cl, 0x40
            //   0f8428010000         | je                  0x12e
            //   f6c120               | test                cl, 0x20

        $sequence_8 = { 42 bf08000000 89542410 c6041600 85ed }
            // n = 5, score = 100
            //   42                   | inc                 edx
            //   bf08000000           | mov                 edi, 8
            //   89542410             | mov                 dword ptr [esp + 0x10], edx
            //   c6041600             | mov                 byte ptr [esi + edx], 0
            //   85ed                 | test                ebp, ebp

        $sequence_9 = { 48 234508 8d0440 8d0441 0fb64801 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   234508               | and                 eax, dword ptr [ebp + 8]
            //   8d0440               | lea                 eax, [eax + eax*2]
            //   8d0441               | lea                 eax, [ecx + eax*2]
            //   0fb64801             | movzx               ecx, byte ptr [eax + 1]

        $sequence_10 = { 8913 5f d3e7 3bc8 7316 }
            // n = 5, score = 100
            //   8913                 | mov                 dword ptr [ebx], edx
            //   5f                   | pop                 edi
            //   d3e7                 | shl                 edi, cl
            //   3bc8                 | cmp                 ecx, eax
            //   7316                 | jae                 0x18

        $sequence_11 = { 46 6a00 8d849db84dffff 56 }
            // n = 4, score = 100
            //   46                   | inc                 esi
            //   6a00                 | push                0
            //   8d849db84dffff       | lea                 eax, [ebp + ebx*4 - 0xb248]
            //   56                   | push                esi

        $sequence_12 = { 0f8e5b020000 68???????? 68???????? 8d54242c 68???????? 52 }
            // n = 6, score = 100
            //   0f8e5b020000         | jle                 0x261
            //   68????????           |                     
            //   68????????           |                     
            //   8d54242c             | lea                 edx, [esp + 0x2c]
            //   68????????           |                     
            //   52                   | push                edx

        $sequence_13 = { 03f3 8bd9 8dbc379979825a 8bf7 }
            // n = 4, score = 100
            //   03f3                 | add                 esi, ebx
            //   8bd9                 | mov                 ebx, ecx
            //   8dbc379979825a       | lea                 edi, [edi + esi + 0x5a827999]
            //   8bf7                 | mov                 esi, edi

        $sequence_14 = { 81c404010000 c3 56 8d542414 68???????? }
            // n = 5, score = 100
            //   81c404010000         | add                 esp, 0x104
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   68????????           |                     

        $sequence_15 = { c1ee17 c1e709 0bf7 33ce 8bf9 33fa }
            // n = 6, score = 100
            //   c1ee17               | shr                 esi, 0x17
            //   c1e709               | shl                 edi, 9
            //   0bf7                 | or                  esi, edi
            //   33ce                 | xor                 ecx, esi
            //   8bf9                 | mov                 edi, ecx
            //   33fa                 | xor                 edi, edx

    condition:
        7 of them and filesize < 188416
}