rule win_bravonc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bravonc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bravonc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4838 334820 334818 33480c }
            // n = 4, score = 100
            //   8b4838               | mov                 ecx, dword ptr [eax + 0x38]
            //   334820               | xor                 ecx, dword ptr [eax + 0x20]
            //   334818               | xor                 ecx, dword ptr [eax + 0x18]
            //   33480c               | xor                 ecx, dword ptr [eax + 0xc]

        $sequence_1 = { 68???????? e8???????? e8???????? be???????? 68???????? 56 c705????????03000000 }
            // n = 7, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   be????????           |                     
            //   68????????           |                     
            //   56                   | push                esi
            //   c705????????03000000     |     

        $sequence_2 = { 8bce e8???????? eb03 8b7d08 8b1d???????? 8d45f4 }
            // n = 6, score = 100
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   eb03                 | jmp                 5
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b1d????????         |                     
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_3 = { 33480c 334804 51 e8???????? 8b8ec0000000 53 ff75f0 }
            // n = 7, score = 100
            //   33480c               | xor                 ecx, dword ptr [eax + 0xc]
            //   334804               | xor                 ecx, dword ptr [eax + 4]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b8ec0000000         | mov                 ecx, dword ptr [esi + 0xc0]
            //   53                   | push                ebx
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_4 = { 334dec 57 ff75fc 334dfc }
            // n = 4, score = 100
            //   334dec               | xor                 ecx, dword ptr [ebp - 0x14]
            //   57                   | push                edi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   334dfc               | xor                 ecx, dword ptr [ebp - 4]

        $sequence_5 = { 5e c9 c20c00 55 8bec 81ec80020000 53 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec80020000         | sub                 esp, 0x280
            //   53                   | push                ebx

        $sequence_6 = { 57 8bce ff15???????? 8bc6 5f 5e c9 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_7 = { 8945f4 8b06 f7d8 23c1 03f3 8945fc }
            // n = 6, score = 100
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   f7d8                 | neg                 eax
            //   23c1                 | and                 eax, ecx
            //   03f3                 | add                 esi, ebx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_8 = { 334834 6a01 334828 334814 51 }
            // n = 5, score = 100
            //   334834               | xor                 ecx, dword ptr [eax + 0x34]
            //   6a01                 | push                1
            //   334828               | xor                 ecx, dword ptr [eax + 0x28]
            //   334814               | xor                 ecx, dword ptr [eax + 0x14]
            //   51                   | push                ecx

        $sequence_9 = { eb02 33db 6a01 e8???????? 84c0 59 750d }
            // n = 7, score = 100
            //   eb02                 | jmp                 4
            //   33db                 | xor                 ebx, ebx
            //   6a01                 | push                1
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   59                   | pop                 ecx
            //   750d                 | jne                 0xf

    condition:
        7 of them and filesize < 131072
}