rule win_breach_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.breach_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.breach_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2b4da4 f7e9 c1fa02 8bc2 c1e81f 03c2 744a }
            // n = 7, score = 200
            //   2b4da4               | sub                 ecx, dword ptr [ebp - 0x5c]
            //   f7e9                 | imul                ecx
            //   c1fa02               | sar                 edx, 2
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03c2                 | add                 eax, edx
            //   744a                 | je                  0x4c

        $sequence_1 = { 8b450c 2bf0 83c002 0345f0 56 50 eb08 }
            // n = 7, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   2bf0                 | sub                 esi, eax
            //   83c002               | add                 eax, 2
            //   0345f0               | add                 eax, dword ptr [ebp - 0x10]
            //   56                   | push                esi
            //   50                   | push                eax
            //   eb08                 | jmp                 0xa

        $sequence_2 = { 8d4db8 e8???????? 83c410 84c0 742c 8b4dd4 }
            // n = 6, score = 200
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   84c0                 | test                al, al
            //   742c                 | je                  0x2e
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]

        $sequence_3 = { ff4dc4 895d08 0f8548fdffff 8b5d98 8b7d9c 85db }
            // n = 6, score = 200
            //   ff4dc4               | dec                 dword ptr [ebp - 0x3c]
            //   895d08               | mov                 dword ptr [ebp + 8], ebx
            //   0f8548fdffff         | jne                 0xfffffd4e
            //   8b5d98               | mov                 ebx, dword ptr [ebp - 0x68]
            //   8b7d9c               | mov                 edi, dword ptr [ebp - 0x64]
            //   85db                 | test                ebx, ebx

        $sequence_4 = { c745bc00000000 c645ac00 56 8bd7 c645fc0b 8d8d6cffffff e8???????? }
            // n = 7, score = 200
            //   c745bc00000000       | mov                 dword ptr [ebp - 0x44], 0
            //   c645ac00             | mov                 byte ptr [ebp - 0x54], 0
            //   56                   | push                esi
            //   8bd7                 | mov                 edx, edi
            //   c645fc0b             | mov                 byte ptr [ebp - 4], 0xb
            //   8d8d6cffffff         | lea                 ecx, [ebp - 0x94]
            //   e8????????           |                     

        $sequence_5 = { 8bc2 c1e81f 03c2 83f807 7616 8d87a8000000 3bf0 }
            // n = 7, score = 200
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03c2                 | add                 eax, edx
            //   83f807               | cmp                 eax, 7
            //   7616                 | jbe                 0x18
            //   8d87a8000000         | lea                 eax, [edi + 0xa8]
            //   3bf0                 | cmp                 esi, eax

        $sequence_6 = { 53 57 8b7d08 33db 895df0 85ff 7464 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   33db                 | xor                 ebx, ebx
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   85ff                 | test                edi, edi
            //   7464                 | je                  0x66

        $sequence_7 = { e8???????? 8bc8 e8???????? 8d8d24f1ffff c745fcffffffff e8???????? 68???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8d8d24f1ffff         | lea                 ecx, [ebp - 0xedc]
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_8 = { e8???????? 50 8d8c2480000000 e8???????? 8b442428 85c0 7416 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d8c2480000000       | lea                 ecx, [esp + 0x80]
            //   e8????????           |                     
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18

        $sequence_9 = { 68???????? 8d8d54f7ffff e8???????? 68???????? 8d8554f7ffff c745fcc8000000 50 }
            // n = 7, score = 200
            //   68????????           |                     
            //   8d8d54f7ffff         | lea                 ecx, [ebp - 0x8ac]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d8554f7ffff         | lea                 eax, [ebp - 0x8ac]
            //   c745fcc8000000       | mov                 dword ptr [ebp - 4], 0xc8
            //   50                   | push                eax

    condition:
        7 of them and filesize < 645120
}