rule win_broler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.broler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.broler"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 6a01 53 ff15???????? 8bf0 ff15???????? 3bf3 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   3bf3                 | cmp                 esi, ebx

        $sequence_1 = { 68e9fd0000 ff15???????? 8bc6 c6043e00 8d5001 }
            // n = 5, score = 100
            //   68e9fd0000           | push                0xfde9
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   c6043e00             | mov                 byte ptr [esi + edi], 0
            //   8d5001               | lea                 edx, [eax + 1]

        $sequence_2 = { c785c0feffff0f000000 899dbcfeffff 889dacfeffff 39b5a4feffff }
            // n = 4, score = 100
            //   c785c0feffff0f000000     | mov    dword ptr [ebp - 0x140], 0xf
            //   899dbcfeffff         | mov                 dword ptr [ebp - 0x144], ebx
            //   889dacfeffff         | mov                 byte ptr [ebp - 0x154], bl
            //   39b5a4feffff         | cmp                 dword ptr [ebp - 0x15c], esi

        $sequence_3 = { 8bf0 8d45d4 3bc6 7461 837de810 720c 8b4dd4 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   3bc6                 | cmp                 eax, esi
            //   7461                 | je                  0x63
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   720c                 | jb                  0xe
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]

        $sequence_4 = { 57 8d8da8feffff e8???????? 83c408 33c0 8a4c05f0 8888f8cd4100 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d8da8feffff         | lea                 ecx, [ebp - 0x158]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   33c0                 | xor                 eax, eax
            //   8a4c05f0             | mov                 cl, byte ptr [ebp + eax - 0x10]
            //   8888f8cd4100         | mov                 byte ptr [eax + 0x41cdf8], cl

        $sequence_5 = { 8b3d???????? 53 ffd7 56 ffd7 8d8d70fdffff }
            // n = 6, score = 100
            //   8b3d????????         |                     
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8d8d70fdffff         | lea                 ecx, [ebp - 0x290]

        $sequence_6 = { b8???????? 8db554ffffff c78568ffffff0f000000 e8???????? 8d8570ffffff }
            // n = 5, score = 100
            //   b8????????           |                     
            //   8db554ffffff         | lea                 esi, [ebp - 0xac]
            //   c78568ffffff0f000000     | mov    dword ptr [ebp - 0x98], 0xf
            //   e8????????           |                     
            //   8d8570ffffff         | lea                 eax, [ebp - 0x90]

        $sequence_7 = { 8bdf c1fb18 c1f818 81e3ff000000 3283085a4100 8b5d0c }
            // n = 6, score = 100
            //   8bdf                 | mov                 ebx, edi
            //   c1fb18               | sar                 ebx, 0x18
            //   c1f818               | sar                 eax, 0x18
            //   81e3ff000000         | and                 ebx, 0xff
            //   3283085a4100         | xor                 al, byte ptr [ebx + 0x415a08]
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]

        $sequence_8 = { 3299085a4100 c1fe08 81e6ff000000 8bca c1f908 88580d }
            // n = 6, score = 100
            //   3299085a4100         | xor                 bl, byte ptr [ecx + 0x415a08]
            //   c1fe08               | sar                 esi, 8
            //   81e6ff000000         | and                 esi, 0xff
            //   8bca                 | mov                 ecx, edx
            //   c1f908               | sar                 ecx, 8
            //   88580d               | mov                 byte ptr [eax + 0xd], bl

        $sequence_9 = { 83fb10 7305 8d5508 8bca 2bc6 83e819 50 }
            // n = 7, score = 100
            //   83fb10               | cmp                 ebx, 0x10
            //   7305                 | jae                 7
            //   8d5508               | lea                 edx, [ebp + 8]
            //   8bca                 | mov                 ecx, edx
            //   2bc6                 | sub                 eax, esi
            //   83e819               | sub                 eax, 0x19
            //   50                   | push                eax

    condition:
        7 of them and filesize < 275456
}