rule win_bruh_wiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bruh_wiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bruh_wiper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a03 6800000040 68???????? ff15???????? 8b1d???????? 8bf8 6a00 }
            // n = 7, score = 100
            //   6a03                 | push                3
            //   6800000040           | push                0x40000000
            //   68????????           |                     
            //   ff15????????         |                     
            //   8b1d????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   6a00                 | push                0

        $sequence_1 = { e8???????? 83c40c be01080000 0f1f8000000000 6a00 8d85f8fdffff }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   be01080000           | mov                 esi, 0x801
            //   0f1f8000000000       | nop                 dword ptr [eax]
            //   6a00                 | push                0
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]

        $sequence_2 = { ffd3 83ee01 75e3 8b4dfc 5f 5e }
            // n = 6, score = 100
            //   ffd3                 | call                ebx
            //   83ee01               | sub                 esi, 1
            //   75e3                 | jne                 0xffffffe5
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_3 = { ffd7 8d45f0 50 6a06 6a00 6a00 6a00 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   6a06                 | push                6
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_4 = { 66a1???????? 668945f4 a0???????? 56 8845f6 8d45f4 57 }
            // n = 7, score = 100
            //   66a1????????         |                     
            //   668945f4             | mov                 word ptr [ebp - 0xc], ax
            //   a0????????           |                     
            //   56                   | push                esi
            //   8845f6               | mov                 byte ptr [ebp - 0xa], al
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   57                   | push                edi

        $sequence_5 = { 57 ffd3 83ee01 75e3 8b4dfc 5f }
            // n = 6, score = 100
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   83ee01               | sub                 esi, 1
            //   75e3                 | jne                 0xffffffe5
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi

        $sequence_6 = { 50 6a00 6a01 6a13 ffd7 8d45f0 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a13                 | push                0x13
            //   ffd7                 | call                edi
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_7 = { 57 ffd3 6800020000 8d85fcfdffff 6a00 50 e8???????? }
            // n = 7, score = 100
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   6800020000           | push                0x200
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 83ec10 a1???????? 33c5 8945fc 66a1???????? 668945f4 }
            // n = 6, score = 100
            //   83ec10               | sub                 esp, 0x10
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   66a1????????         |                     
            //   668945f4             | mov                 word ptr [ebp - 0xc], ax

        $sequence_9 = { 57 ffd3 83ee01 75e3 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   83ee01               | sub                 esi, 1
            //   75e3                 | jne                 0xffffffe5

    condition:
        7 of them and filesize < 65536
}