rule win_brute_ratel_c4_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.brute_ratel_c4."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.brute_ratel_c4"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89542410 48894c2408 4883ec48 8b442458 89442424 48c744242800000000 41b800060400 }
            // n = 7, score = 100
            //   89542410             | mov                 dword ptr [esp + 0x28], 0
            //   48894c2408           | inc                 ecx
            //   4883ec48             | mov                 eax, 0x40600
            //   8b442458             | dec                 eax
            //   89442424             | lea                 edx, [0x2fd0]
            //   48c744242800000000     | dec    eax
            //   41b800060400         | lea                 ecx, [0x42ee3]

        $sequence_1 = { 89442438 4863442430 486bc010 488d0de32e0400 4803c8 }
            // n = 5, score = 100
            //   89442438             | dec                 eax
            //   4863442430           | lea                 ecx, [esp + 0x20]
            //   486bc010             | dec                 eax
            //   488d0de32e0400       | mov                 dword ptr [esp + 0x28], eax
            //   4803c8               | dec                 esp

        $sequence_2 = { 488d0de32e0400 4803c8 488bc1 48634c2434 }
            // n = 4, score = 100
            //   488d0de32e0400       | dec                 eax
            //   4803c8               | lea                 ecx, [0x42ee3]
            //   488bc1               | dec                 eax
            //   48634c2434           | add                 ecx, eax

        $sequence_3 = { 48c744242800000000 41b800060400 488d15d02f0000 488d4c2420 e8???????? 4889442428 4c8d0532200000 }
            // n = 7, score = 100
            //   48c744242800000000     | dec    eax
            //   41b800060400         | mov                 dword ptr [esp + 0x28], 0
            //   488d15d02f0000       | inc                 ecx
            //   488d4c2420           | mov                 eax, 0x40600
            //   e8????????           |                     
            //   4889442428           | dec                 eax
            //   4c8d0532200000       | lea                 edx, [0x2fd0]

        $sequence_4 = { 65488b042560000000 4c8b7868 41837f0400 0f84d9000000 }
            // n = 4, score = 100
            //   65488b042560000000     | mov    dword ptr [esp + 0x28], 0
            //   4c8b7868             | inc                 ecx
            //   41837f0400           | mov                 eax, 0x40600
            //   0f84d9000000         | dec                 eax

        $sequence_5 = { 41ffd7 ffcd 85c0 75cd 4801de 48c1e704 }
            // n = 6, score = 100
            //   41ffd7               | lea                 edx, [0x2fd0]
            //   ffcd                 | mov                 dword ptr [esp + 0x2c], 0
            //   85c0                 | mov                 eax, dword ptr [esp + 0x2c]
            //   75cd                 | mov                 dword ptr [esp + 0x38], eax
            //   4801de               | dec                 eax
            //   48c1e704             | arpl                word ptr [esp + 0x30], ax

        $sequence_6 = { 4d85c0 7415 8b4f04 4801f1 49d1e8 4c89f2 41ffd7 }
            // n = 7, score = 100
            //   4d85c0               | dec                 eax
            //   7415                 | mov                 dword ptr [esp + 8], ecx
            //   8b4f04               | dec                 eax
            //   4801f1               | sub                 esp, 0x48
            //   49d1e8               | mov                 eax, dword ptr [esp + 0x58]
            //   4c89f2               | mov                 dword ptr [esp + 0x24], eax
            //   41ffd7               | dec                 eax

        $sequence_7 = { 488b542430 41ffd4 85c0 75c9 418b74ff2c 458b74ff30 }
            // n = 6, score = 100
            //   488b542430           | dec                 eax
            //   41ffd4               | lea                 edx, [0x2fd0]
            //   85c0                 | dec                 eax
            //   75c9                 | lea                 ecx, [esp + 0x20]
            //   418b74ff2c           | mov                 dword ptr [esp + 0x38], eax
            //   458b74ff30           | dec                 eax

        $sequence_8 = { 83f804 0f8495010000 83f806 0f85b8010000 65488b042560000000 4c8b7868 41837f0c00 }
            // n = 7, score = 100
            //   83f804               | arpl                word ptr [esp + 0x30], ax
            //   0f8495010000         | dec                 eax
            //   83f806               | imul                eax, eax, 0x10
            //   0f85b8010000         | dec                 eax
            //   65488b042560000000     | lea    ecx, [0x42ee3]
            //   4c8b7868             | dec                 eax
            //   41837f0c00           | add                 ecx, eax

        $sequence_9 = { 4189c4 85c0 0f853bffffff 4989f8 }
            // n = 4, score = 100
            //   4189c4               | dec                 eax
            //   85c0                 | mov                 dword ptr [esp + 0x28], 0
            //   0f853bffffff         | inc                 ecx
            //   4989f8               | mov                 eax, 0x40600

        $sequence_10 = { ffcd 90 85ed 78bc }
            // n = 4, score = 100
            //   ffcd                 | dec                 eax
            //   90                   | lea                 edx, [0x2fd0]
            //   85ed                 | dec                 eax
            //   78bc                 | lea                 ecx, [esp + 0x20]

        $sequence_11 = { 0fb6c1 f7d8 4883c438 c3 }
            // n = 4, score = 100
            //   0fb6c1               | dec                 eax
            //   f7d8                 | imul                eax, eax, 0x10
            //   4883c438             | dec                 eax
            //   c3                   | lea                 ecx, [0x42ee3]

    condition:
        1 of them and filesize < 607232
}