rule win_bs2005_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bs2005."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bs2005"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 40 84c9 75f9 6a00 8d8dccfeffff 51 2bc2 }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   6a00                 | push                0
            //   8d8dccfeffff         | lea                 ecx, [ebp - 0x134]
            //   51                   | push                ecx
            //   2bc2                 | sub                 eax, edx

        $sequence_1 = { c705????????14864000 a3???????? c705????????408f4000 c705????????30864000 c705????????92854000 }
            // n = 5, score = 100
            //   c705????????14864000     |     
            //   a3????????           |                     
            //   c705????????408f4000     |     
            //   c705????????30864000     |     
            //   c705????????92854000     |     

        $sequence_2 = { 8bcf 2bce 81e91c010c00 51 8d5705 52 83c020 }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   2bce                 | sub                 ecx, esi
            //   81e91c010c00         | sub                 ecx, 0xc011c
            //   51                   | push                ecx
            //   8d5705               | lea                 edx, [edi + 5]
            //   52                   | push                edx
            //   83c020               | add                 eax, 0x20

        $sequence_3 = { 52 6a04 50 8945e4 8b45e8 68???????? 50 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   6a04                 | push                4
            //   50                   | push                eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_4 = { 8945f8 ba00040000 8bcf c60100 }
            // n = 4, score = 100
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   ba00040000           | mov                 edx, 0x400
            //   8bcf                 | mov                 ecx, edi
            //   c60100               | mov                 byte ptr [ecx], 0

        $sequence_5 = { 8b8e04010000 6a00 6a00 50 51 c745fc00000000 }
            // n = 6, score = 100
            //   8b8e04010000         | mov                 ecx, dword ptr [esi + 0x104]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   50                   | push                eax
            //   51                   | push                ecx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_6 = { 8b06 85c0 7425 8b10 50 }
            // n = 5, score = 100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   85c0                 | test                eax, eax
            //   7425                 | je                  0x27
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   50                   | push                eax

        $sequence_7 = { 75f9 b900000400 8d860c010c00 c60000 40 49 75f9 }
            // n = 7, score = 100
            //   75f9                 | jne                 0xfffffffb
            //   b900000400           | mov                 ecx, 0x40000
            //   8d860c010c00         | lea                 eax, [esi + 0xc010c]
            //   c60000               | mov                 byte ptr [eax], 0
            //   40                   | inc                 eax
            //   49                   | dec                 ecx
            //   75f9                 | jne                 0xfffffffb

        $sequence_8 = { 8b860c010000 3d00000200 7205 b800000200 8b8e04010000 6a00 }
            // n = 6, score = 100
            //   8b860c010000         | mov                 eax, dword ptr [esi + 0x10c]
            //   3d00000200           | cmp                 eax, 0x20000
            //   7205                 | jb                  7
            //   b800000200           | mov                 eax, 0x20000
            //   8b8e04010000         | mov                 ecx, dword ptr [esi + 0x104]
            //   6a00                 | push                0

        $sequence_9 = { 6a00 8d55fc 52 50 8d8612010000 50 51 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d8612010000         | lea                 eax, [esi + 0x112]
            //   50                   | push                eax
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 212992
}