rule win_buhtrap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.buhtrap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.buhtrap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 59 59 84c0 0f8435010000 }
            // n = 5, score = 500
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   84c0                 | test                al, al
            //   0f8435010000         | je                  0x13b

        $sequence_1 = { ff5010 837df000 0f84e7000000 85c0 0f85c9000000 }
            // n = 5, score = 400
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   0f84e7000000         | je                  0xed
            //   85c0                 | test                eax, eax
            //   0f85c9000000         | jne                 0xcf

        $sequence_2 = { 8d442454 50 53 6a0a 5a e8???????? 50 }
            // n = 7, score = 400
            //   8d442454             | lea                 eax, [esp + 0x54]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   6a0a                 | push                0xa
            //   5a                   | pop                 edx
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_3 = { 53 ffd6 8bd8 2b5dfc 895dec }
            // n = 5, score = 400
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   8bd8                 | mov                 ebx, eax
            //   2b5dfc               | sub                 ebx, dword ptr [ebp - 4]
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx

        $sequence_4 = { 66895dec 8bf3 8afb 8bc6 8a9c35ecfeffff }
            // n = 5, score = 400
            //   66895dec             | mov                 word ptr [ebp - 0x14], bx
            //   8bf3                 | mov                 esi, ebx
            //   8afb                 | mov                 bh, bl
            //   8bc6                 | mov                 eax, esi
            //   8a9c35ecfeffff       | mov                 bl, byte ptr [ebp + esi - 0x114]

        $sequence_5 = { 8d4df0 51 8d4df8 51 6a01 6aff 52 }
            // n = 7, score = 400
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   51                   | push                ecx
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   6a01                 | push                1
            //   6aff                 | push                -1
            //   52                   | push                edx

        $sequence_6 = { 57 ffd6 57 8945fc ffd6 59 59 }
            // n = 7, score = 400
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   57                   | push                edi
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_7 = { ba0a010000 b9???????? e8???????? 83ec0c be???????? }
            // n = 5, score = 400
            //   ba0a010000           | mov                 edx, 0x10a
            //   b9????????           |                     
            //   e8????????           |                     
            //   83ec0c               | sub                 esp, 0xc
            //   be????????           |                     

        $sequence_8 = { ff75f4 ff15???????? 8b45e8 5e }
            // n = 4, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   5e                   | pop                 esi

        $sequence_9 = { 8d742414 c744241401234567 c744241889abcdef c744241cfedcba98 }
            // n = 4, score = 100
            //   8d742414             | lea                 esi, [esp + 0x14]
            //   c744241401234567     | mov                 dword ptr [esp + 0x14], 0x67452301
            //   c744241889abcdef     | mov                 dword ptr [esp + 0x18], 0xefcdab89
            //   c744241cfedcba98     | mov                 dword ptr [esp + 0x1c], 0x98badcfe

        $sequence_10 = { 8945fc 8a040a 8801 41 }
            // n = 4, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8a040a               | mov                 al, byte ptr [edx + ecx]
            //   8801                 | mov                 byte ptr [ecx], al
            //   41                   | inc                 ecx

        $sequence_11 = { c645ff00 897df8 3bdf 0f84ad010000 8b4634 }
            // n = 5, score = 100
            //   c645ff00             | mov                 byte ptr [ebp - 1], 0
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   3bdf                 | cmp                 ebx, edi
            //   0f84ad010000         | je                  0x1b3
            //   8b4634               | mov                 eax, dword ptr [esi + 0x34]

        $sequence_12 = { 807d1000 50 ff7508 740c }
            // n = 4, score = 100
            //   807d1000             | cmp                 byte ptr [ebp + 0x10], 0
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   740c                 | je                  0xe

        $sequence_13 = { 8b4508 c7403401000000 8b45f8 3bc6 }
            // n = 4, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c7403401000000       | mov                 dword ptr [eax + 0x34], 1
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   3bc6                 | cmp                 eax, esi

        $sequence_14 = { 765c 837c241000 7655 51 e8???????? 59 }
            // n = 6, score = 100
            //   765c                 | jbe                 0x5e
            //   837c241000           | cmp                 dword ptr [esp + 0x10], 0
            //   7655                 | jbe                 0x57
            //   51                   | push                ecx
            //   e8????????           |                     
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 131072
}