rule win_bumblebee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bumblebee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bumblebee"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bd5 4889442428 498bce 488364242000 }
            // n = 4, score = 3500
            //   488bd5               | lea                 eax, [0xecddd]
            //   4889442428           | dec                 eax
            //   498bce               | mov                 dword ptr [ebp + 0x20], eax
            //   488364242000         | dec                 eax

        $sequence_1 = { 85c0 783c 488b9508030000 4885d2 }
            // n = 4, score = 3500
            //   85c0                 | mov                 dword ptr [ebp + 0x200], 3
            //   783c                 | dec                 eax
            //   488b9508030000       | mov                 dword ptr [ebp + 0x1f0], 4
            //   4885d2               | dec                 eax

        $sequence_2 = { 4885c0 0f84b5000000 488d4c2430 41b900100000 48894c2420 4c8bc3 498bce }
            // n = 7, score = 3500
            //   4885c0               | inc                 ebp
            //   0f84b5000000         | mov                 eax, edi
            //   488d4c2430           | inc                 ecx
            //   41b900100000         | lea                 edx, [ecx + 2]
            //   48894c2420           | inc                 ebp
            //   4c8bc3               | xor                 ecx, ecx
            //   498bce               | dec                 eax

        $sequence_3 = { 33d2 488b4dc8 e8???????? 488b4dc8 }
            // n = 4, score = 3500
            //   33d2                 | mov                 dword ptr [ecx], eax
            //   488b4dc8             | xor                 eax, eax
            //   e8????????           |                     
            //   488b4dc8             | dec                 eax

        $sequence_4 = { 90 ba38000000 488bcb e8???????? 90 }
            // n = 5, score = 3500
            //   90                   | dec                 eax
            //   ba38000000           | lea                 eax, [0x1863df]
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [ebx], eax

        $sequence_5 = { 4885f6 0f84ff000000 488b05???????? 4885c0 0f84ef000000 488d4c2430 41b900100000 }
            // n = 7, score = 3500
            //   4885f6               | sub                 esp, eax
            //   0f84ff000000         | mov                 ebp, edx
            //   488b05????????       |                     
            //   4885c0               | inc                 esp
            //   0f84ef000000         | lea                 eax, [eax + 0x45]
            //   488d4c2430           | dec                 eax
            //   41b900100000         | mov                 edi, ecx

        $sequence_6 = { 488364242000 ffd7 8bc8 ffd3 }
            // n = 4, score = 3500
            //   488364242000         | xor                 eax, ecx
            //   ffd7                 | inc                 esp
            //   8bc8                 | mov                 eax, eax
            //   ffd3                 | mov                 dword ptr [ebp - 0x68], eax

        $sequence_7 = { 488bd8 ff15???????? 488bcf 488945e5 }
            // n = 4, score = 3500
            //   488bd8               | dec                 eax
            //   ff15????????         |                     
            //   488bcf               | lea                 edx, [ebp - 0x59]
            //   488945e5             | dec                 eax

        $sequence_8 = { 488364242000 ffd7 8bc8 ffd3 4c8d5c2460 498b5b20 498b6b28 }
            // n = 7, score = 3500
            //   488364242000         | movzx               ecx, al
            //   ffd7                 | movzx               eax, dl
            //   8bc8                 | mov                 edx, dword ptr [esi + ecx*4 + 0x189d20]
            //   ffd3                 | xor                 edx, dword ptr [esi + eax*4 + 0x18a120]
            //   4c8d5c2460           | inc                 esp
            //   498b5b20             | mov                 eax, edx
            //   498b6b28             | mov                 eax, edx

        $sequence_9 = { ff15???????? 488d4c2438 33d2 48894c2420 448d4f30 }
            // n = 5, score = 3500
            //   ff15????????         |                     
            //   488d4c2438           | lea                 edx, [0x805bd]
            //   33d2                 | mov                 al, 1
            //   48894c2420           | dec                 eax
            //   448d4f30             | add                 esp, 0x28

    condition:
        7 of them and filesize < 4825088
}