rule win_bunnyloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bunnyloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bunnyloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff742414 ba40000000 8bcf ff750c 50 e8???????? 83c40c }
            // n = 7, score = 100
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   ba40000000           | mov                 edx, 0x40
            //   8bcf                 | mov                 ecx, edi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_1 = { e9???????? 8b4318 8b560c 89542420 a828 745a b9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b4318               | mov                 eax, dword ptr [ebx + 0x18]
            //   8b560c               | mov                 edx, dword ptr [esi + 0xc]
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   a828                 | test                al, 0x28
            //   745a                 | je                  0x5c
            //   b9????????           |                     

        $sequence_2 = { c745dc00000000 89857cffffff 7432 50 8d4dd4 e8???????? ffb57cffffff }
            // n = 7, score = 100
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   89857cffffff         | mov                 dword ptr [ebp - 0x84], eax
            //   7432                 | je                  0x34
            //   50                   | push                eax
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     
            //   ffb57cffffff         | push                dword ptr [ebp - 0x84]

        $sequence_3 = { 894df4 85c9 743a 8bc8 33c0 83c101 13c0 }
            // n = 7, score = 100
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   85c9                 | test                ecx, ecx
            //   743a                 | je                  0x3c
            //   8bc8                 | mov                 ecx, eax
            //   33c0                 | xor                 eax, eax
            //   83c101               | add                 ecx, 1
            //   13c0                 | adc                 eax, eax

        $sequence_4 = { c6853fffffff00 8d95b8feffff ffb53fffffff 8d8df8fdffff c645fc2d e8???????? 83c404 }
            // n = 7, score = 100
            //   c6853fffffff00       | mov                 byte ptr [ebp - 0xc1], 0
            //   8d95b8feffff         | lea                 edx, [ebp - 0x148]
            //   ffb53fffffff         | push                dword ptr [ebp - 0xc1]
            //   8d8df8fdffff         | lea                 ecx, [ebp - 0x208]
            //   c645fc2d             | mov                 byte ptr [ebp - 4], 0x2d
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_5 = { e8???????? 8b4df8 83c408 8b550c 6689044a 8a06 3c20 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   83c408               | add                 esp, 8
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   6689044a             | mov                 word ptr [edx + ecx*2], ax
            //   8a06                 | mov                 al, byte ptr [esi]
            //   3c20                 | cmp                 al, 0x20

        $sequence_6 = { 8d5e54 8bd3 894650 8bcf e8???????? 8bbd64feffff eb2d }
            // n = 7, score = 100
            //   8d5e54               | lea                 ebx, [esi + 0x54]
            //   8bd3                 | mov                 edx, ebx
            //   894650               | mov                 dword ptr [esi + 0x50], eax
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8bbd64feffff         | mov                 edi, dword ptr [ebp - 0x19c]
            //   eb2d                 | jmp                 0x2f

        $sequence_7 = { e8???????? 83c408 e9???????? 8b442420 807c241700 0f8418030000 807e5700 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   e9????????           |                     
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   807c241700           | cmp                 byte ptr [esp + 0x17], 0
            //   0f8418030000         | je                  0x31e
            //   807e5700             | cmp                 byte ptr [esi + 0x57], 0

        $sequence_8 = { e8???????? 8bf8 8b45e4 03fe 13d3 83c701 13d3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   03fe                 | add                 edi, esi
            //   13d3                 | adc                 edx, ebx
            //   83c701               | add                 edi, 1
            //   13d3                 | adc                 edx, ebx

        $sequence_9 = { c6464400 8a4201 884645 803a00 746e 0fb64201 33c9 }
            // n = 7, score = 100
            //   c6464400             | mov                 byte ptr [esi + 0x44], 0
            //   8a4201               | mov                 al, byte ptr [edx + 1]
            //   884645               | mov                 byte ptr [esi + 0x45], al
            //   803a00               | cmp                 byte ptr [edx], 0
            //   746e                 | je                  0x70
            //   0fb64201             | movzx               eax, byte ptr [edx + 1]
            //   33c9                 | xor                 ecx, ecx

    condition:
        7 of them and filesize < 2998272
}