rule win_byeby_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.byeby."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.byeby"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c78424a002000059335630 c68424a402000000 50 8d8424380a0000 50 ff15???????? }
            // n = 6, score = 100
            //   c78424a002000059335630     | mov    dword ptr [esp + 0x2a0], 0x30563359
            //   c68424a402000000     | mov                 byte ptr [esp + 0x2a4], 0
            //   50                   | push                eax
            //   8d8424380a0000       | lea                 eax, [esp + 0xa38]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { c68424d402000000 c784242c0300005130394e c78424300300005455464f c684243403000000 c78424e402000056464a42 c78424e8020000546c4e47 c68424ec02000000 }
            // n = 7, score = 100
            //   c68424d402000000     | mov                 byte ptr [esp + 0x2d4], 0
            //   c784242c0300005130394e     | mov    dword ptr [esp + 0x32c], 0x4e393051
            //   c78424300300005455464f     | mov    dword ptr [esp + 0x330], 0x4f465554
            //   c684243403000000     | mov                 byte ptr [esp + 0x334], 0
            //   c78424e402000056464a42     | mov    dword ptr [esp + 0x2e4], 0x424a4656
            //   c78424e8020000546c4e47     | mov    dword ptr [esp + 0x2e8], 0x474e6c54
            //   c68424ec02000000     | mov                 byte ptr [esp + 0x2ec], 0

        $sequence_2 = { 8d85c0f9ffff 66c745e80d0a 6804050000 50 f30f7f45d4 c645ea00 }
            // n = 6, score = 100
            //   8d85c0f9ffff         | lea                 eax, [ebp - 0x640]
            //   66c745e80d0a         | mov                 word ptr [ebp - 0x18], 0xa0d
            //   6804050000           | push                0x504
            //   50                   | push                eax
            //   f30f7f45d4           | movdqu              xmmword ptr [ebp - 0x2c], xmm0
            //   c645ea00             | mov                 byte ptr [ebp - 0x16], 0

        $sequence_3 = { 50 8b8528e5ffff 0f94c1 898d3ce5ffff 8b8d24e5ffff 8b048518ab0110 ff3401 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b8528e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad8]
            //   0f94c1               | sete                cl
            //   898d3ce5ffff         | mov                 dword ptr [ebp - 0x1ac4], ecx
            //   8b8d24e5ffff         | mov                 ecx, dword ptr [ebp - 0x1adc]
            //   8b048518ab0110       | mov                 eax, dword ptr [eax*4 + 0x1001ab18]
            //   ff3401               | push                dword ptr [ecx + eax]

        $sequence_4 = { 85c0 7411 ff35???????? 8bc8 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   ff35????????         |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_5 = { 8bf0 83feff 0f8489000000 6a00 56 ff15???????? 3d00900100 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   83feff               | cmp                 esi, -1
            //   0f8489000000         | je                  0x8f
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     
            //   3d00900100           | cmp                 eax, 0x19000

        $sequence_6 = { 894c2428 ff15???????? 85c0 7430 8b7c2414 8d4900 83f8ff }
            // n = 7, score = 100
            //   894c2428             | mov                 dword ptr [esp + 0x28], ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7430                 | je                  0x32
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   8d4900               | lea                 ecx, [ecx]
            //   83f8ff               | cmp                 eax, -1

        $sequence_7 = { 64890d00000000 59 5f 5e 8b8c243c100000 33cc }
            // n = 6, score = 100
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8b8c243c100000       | mov                 ecx, dword ptr [esp + 0x103c]
            //   33cc                 | xor                 ecx, esp

        $sequence_8 = { 0fbec2 0fb680d0450110 83e00f eb02 33c0 8bbdc8fdffff 6bc009 }
            // n = 7, score = 100
            //   0fbec2               | movsx               eax, dl
            //   0fb680d0450110       | movzx               eax, byte ptr [eax + 0x100145d0]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8bbdc8fdffff         | mov                 edi, dword ptr [ebp - 0x238]
            //   6bc009               | imul                eax, eax, 9

        $sequence_9 = { 740b 8d44246c 50 ff15???????? 8b442430 85c0 7409 }
            // n = 7, score = 100
            //   740b                 | je                  0xd
            //   8d44246c             | lea                 eax, [esp + 0x6c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb

    condition:
        7 of them and filesize < 253952
}