rule win_c0d0so0_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.c0d0so0."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.c0d0so0"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a04 bf00200000 57 ff7350 ff7334 ffd6 }
            // n = 6, score = 600
            //   6a04                 | push                4
            //   bf00200000           | mov                 edi, 0x2000
            //   57                   | push                edi
            //   ff7350               | push                dword ptr [ebx + 0x50]
            //   ff7334               | push                dword ptr [ebx + 0x34]
            //   ffd6                 | call                esi

        $sequence_1 = { 837d0c00 7404 0006 eb02 2806 0fb6c0 }
            // n = 6, score = 600
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   7404                 | je                  6
            //   0006                 | add                 byte ptr [esi], al
            //   eb02                 | jmp                 4
            //   2806                 | sub                 byte ptr [esi], al
            //   0fb6c0               | movzx               eax, al

        $sequence_2 = { ff15???????? eb46 8d0c4e 8d0c4f }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   eb46                 | jmp                 0x48
            //   8d0c4e               | lea                 ecx, [esi + ecx*2]
            //   8d0c4f               | lea                 ecx, [edi + ecx*2]

        $sequence_3 = { ff15???????? 85c0 7423 6683780802 }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7423                 | je                  0x25
            //   6683780802           | cmp                 word ptr [eax + 8], 2

        $sequence_4 = { 33c0 5d c3 8b503c 813c1050450000 75f0 8bd7 }
            // n = 7, score = 600
            //   33c0                 | xor                 eax, eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b503c               | mov                 edx, dword ptr [eax + 0x3c]
            //   813c1050450000       | cmp                 dword ptr [eax + edx], 0x4550
            //   75f0                 | jne                 0xfffffff2
            //   8bd7                 | mov                 edx, edi

        $sequence_5 = { 7421 8345f814 8b45f8 6a14 83c0f0 50 }
            // n = 6, score = 600
            //   7421                 | je                  0x23
            //   8345f814             | add                 dword ptr [ebp - 8], 0x14
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   6a14                 | push                0x14
            //   83c0f0               | add                 eax, -0x10
            //   50                   | push                eax

        $sequence_6 = { c1ea10 ff4dfc 8813 43 837dfc00 7fe7 8b5508 }
            // n = 7, score = 600
            //   c1ea10               | shr                 edx, 0x10
            //   ff4dfc               | dec                 dword ptr [ebp - 4]
            //   8813                 | mov                 byte ptr [ebx], dl
            //   43                   | inc                 ebx
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7fe7                 | jg                  0xffffffe9
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_7 = { 741f 4a 7417 4a 740f }
            // n = 5, score = 600
            //   741f                 | je                  0x21
            //   4a                   | dec                 edx
            //   7417                 | je                  0x19
            //   4a                   | dec                 edx
            //   740f                 | je                  0x11

        $sequence_8 = { eb62 8d45f4 50 57 8d45fc }
            // n = 5, score = 600
            //   eb62                 | jmp                 0x64
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   57                   | push                edi
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_9 = { 85c0 740f 8b00 47 89048e 41 }
            // n = 6, score = 600
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   47                   | inc                 edi
            //   89048e               | mov                 dword ptr [esi + ecx*4], eax
            //   41                   | inc                 ecx

    condition:
        7 of them and filesize < 450560
}