rule win_cabart_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cabart."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cabart"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 be04010000 8d85d8fbffff 56 }
            // n = 4, score = 300
            //   57                   | push                edi
            //   be04010000           | mov                 esi, 0x104
            //   8d85d8fbffff         | lea                 eax, [ebp - 0x428]
            //   56                   | push                esi

        $sequence_1 = { 5f 40 5e c9 c21000 53 }
            // n = 6, score = 300
            //   5f                   | pop                 edi
            //   40                   | inc                 eax
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c21000               | ret                 0x10
            //   53                   | push                ebx

        $sequence_2 = { 55 a3???????? ffd6 68???????? ff742414 a3???????? ffd6 }
            // n = 7, score = 300
            //   55                   | push                ebp
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   a3????????           |                     
            //   ffd6                 | call                esi

        $sequence_3 = { 395d10 740f 6800800000 53 ff7510 }
            // n = 5, score = 300
            //   395d10               | cmp                 dword ptr [ebp + 0x10], ebx
            //   740f                 | je                  0x11
            //   6800800000           | push                0x8000
            //   53                   | push                ebx
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_4 = { ff15???????? ff15???????? 57 3db7000000 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   57                   | push                edi
            //   3db7000000           | cmp                 eax, 0xb7

        $sequence_5 = { 761e 8b450c 8930 8b4510 eb16 }
            // n = 5, score = 300
            //   761e                 | jbe                 0x20
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8930                 | mov                 dword ptr [eax], esi
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   eb16                 | jmp                 0x18

        $sequence_6 = { 8d85fcfeffff 68???????? 6804010000 50 ff15???????? 83c410 6a10 }
            // n = 7, score = 300
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   68????????           |                     
            //   6804010000           | push                0x104
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   6a10                 | push                0x10

        $sequence_7 = { 3bf3 0f8499000000 53 53 53 53 }
            // n = 6, score = 300
            //   3bf3                 | cmp                 esi, ebx
            //   0f8499000000         | je                  0x9f
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_8 = { 57 ff15???????? 83c428 33c0 5f }
            // n = 5, score = 300
            //   57                   | push                edi
            //   ff15????????         |                     
            //   83c428               | add                 esp, 0x28
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi

        $sequence_9 = { 6a02 57 6a01 6800000040 8d85fcfbffff }
            // n = 5, score = 300
            //   6a02                 | push                2
            //   57                   | push                edi
            //   6a01                 | push                1
            //   6800000040           | push                0x40000000
            //   8d85fcfbffff         | lea                 eax, [ebp - 0x404]

    condition:
        7 of them and filesize < 32768
}