rule win_campoloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.campoloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.campoloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2b4dd8 894dd4 8b55f8 0355d4 8955f8 8b45f8 }
            // n = 6, score = 200
            //   2b4dd8               | sub                 ecx, dword ptr [ebp - 0x28]
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   0355d4               | add                 edx, dword ptr [ebp - 0x2c]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_1 = { 7407 33c0 e9???????? c78548efffff00000000 8d8de8fcffff 898d7cefffff }
            // n = 6, score = 200
            //   7407                 | je                  9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   c78548efffff00000000     | mov    dword ptr [ebp - 0x10b8], 0
            //   8d8de8fcffff         | lea                 ecx, [ebp - 0x318]
            //   898d7cefffff         | mov                 dword ptr [ebp - 0x1084], ecx

        $sequence_2 = { 898568efffff 8d95f0feffff 52 ff15???????? 898550efffff 0fb78554efffff 50 }
            // n = 7, score = 200
            //   898568efffff         | mov                 dword ptr [ebp - 0x1098], eax
            //   8d95f0feffff         | lea                 edx, [ebp - 0x110]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   898550efffff         | mov                 dword ptr [ebp - 0x10b0], eax
            //   0fb78554efffff       | movzx               eax, word ptr [ebp - 0x10ac]
            //   50                   | push                eax

        $sequence_3 = { 8bec b8bc100000 e8???????? a1???????? 33c5 8945fc a1???????? }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   b8bc100000           | mov                 eax, 0x10bc
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   a1????????           |                     

        $sequence_4 = { 8b55f8 0355d4 8955f8 8b45f8 }
            // n = 4, score = 200
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   0355d4               | add                 edx, dword ptr [ebp - 0x2c]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_5 = { 8a11 8855e4 8345d001 807de400 75ee 8b45d0 2b45a4 }
            // n = 7, score = 200
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8855e4               | mov                 byte ptr [ebp - 0x1c], dl
            //   8345d001             | add                 dword ptr [ebp - 0x30], 1
            //   807de400             | cmp                 byte ptr [ebp - 0x1c], 0
            //   75ee                 | jne                 0xfffffff0
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   2b45a4               | sub                 eax, dword ptr [ebp - 0x5c]

        $sequence_6 = { e8???????? 83c404 89856cefffff 8b958cefffff 2b956cefffff 89958cefffff c78564efffff00000000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89856cefffff         | mov                 dword ptr [ebp - 0x1094], eax
            //   8b958cefffff         | mov                 edx, dword ptr [ebp - 0x1074]
            //   2b956cefffff         | sub                 edx, dword ptr [ebp - 0x1094]
            //   89958cefffff         | mov                 dword ptr [ebp - 0x1074], edx
            //   c78564efffff00000000     | mov    dword ptr [ebp - 0x109c], 0

        $sequence_7 = { ff15???????? 898550efffff 0fb78554efffff 50 ff15???????? 66898522f1ffff b902000000 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   898550efffff         | mov                 dword ptr [ebp - 0x10b0], eax
            //   0fb78554efffff       | movzx               eax, word ptr [ebp - 0x10ac]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   66898522f1ffff       | mov                 word ptr [ebp - 0xede], ax
            //   b902000000           | mov                 ecx, 2

        $sequence_8 = { 8b45e4 8945ec 8b4dec 83c101 894dd8 }
            // n = 5, score = 200
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   83c101               | add                 ecx, 1
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx

        $sequence_9 = { c745f8ffffffff 8b45e8 50 8b4d08 51 ff15???????? 83c408 }
            // n = 7, score = 200
            //   c745f8ffffffff       | mov                 dword ptr [ebp - 8], 0xffffffff
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8

    condition:
        7 of them and filesize < 66560
}