rule win_carbanak_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.carbanak."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.carbanak"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7c0d e8???????? 84c0 7504 33c0 }
            // n = 5, score = 500
            //   7c0d                 | jl                  0xf
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 7907 32c0 e9???????? 7507 }
            // n = 4, score = 500
            //   7907                 | jns                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   7507                 | jne                 9

        $sequence_2 = { 85c0 7509 e8???????? b001 }
            // n = 4, score = 500
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   e8????????           |                     
            //   b001                 | mov                 al, 1

        $sequence_3 = { e9???????? 7507 b001 e9???????? }
            // n = 4, score = 500
            //   e9????????           |                     
            //   7507                 | jne                 9
            //   b001                 | mov                 al, 1
            //   e9????????           |                     

        $sequence_4 = { e9???????? 3d2c5c0700 750a e8???????? e9???????? }
            // n = 5, score = 500
            //   e9????????           |                     
            //   3d2c5c0700           | cmp                 eax, 0x75c2c
            //   750a                 | jne                 0xc
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_5 = { 488d4dc8 4183c8ff 488bd0 488bd8 e8???????? 488bcb }
            // n = 6, score = 300
            //   488d4dc8             | dec                 eax
            //   4183c8ff             | lea                 ecx, [ebp - 0x38]
            //   488bd0               | inc                 ecx
            //   488bd8               | or                  eax, 0xffffffff
            //   e8????????           |                     
            //   488bcb               | dec                 eax

        $sequence_6 = { 41ffc1 ba23000000 48895c2428 48895c2420 e8???????? }
            // n = 5, score = 300
            //   41ffc1               | mov                 ecx, ebx
            //   ba23000000           | inc                 ebp
            //   48895c2428           | mov                 edi, eax
            //   48895c2420           | dec                 eax
            //   e8????????           |                     

        $sequence_7 = { ff75fc 8ad8 e8???????? 83c414 84db 7511 }
            // n = 6, score = 200
            //   ff75fc               | jmp                 8
            //   8ad8                 | add                 eax, 0x27
            //   e8????????           |                     
            //   83c414               | mov                 eax, dword ptr [esi + 8]
            //   84db                 | jmp                 4
            //   7511                 | mov                 eax, ebx

        $sequence_8 = { 6aff 68???????? 6a01 8d4dec 51 }
            // n = 5, score = 200
            //   6aff                 | jne                 9
            //   68????????           |                     
            //   6a01                 | mov                 al, 1
            //   8d4dec               | jg                  7
            //   51                   | add                 eax, 0x61

        $sequence_9 = { 50 50 ff7510 ff750c 50 ff7508 }
            // n = 6, score = 200
            //   50                   | xor                 al, al
            //   50                   | jne                 9
            //   ff7510               | mov                 al, 1
            //   ff750c               | sub                 edx, ecx
            //   50                   | sub                 ecx, 0x1021
            //   ff7508               | mov                 eax, ecx

    condition:
        7 of them and filesize < 658432
}