rule win_carberp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.carberp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.carberp"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff750c 33db ff35???????? e8???????? 8bf0 59 59 }
            // n = 7, score = 200
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   33db                 | xor                 ebx, ebx
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_1 = { 7416 80f92f 7411 80f93d 740c 3bc6 7e04 }
            // n = 7, score = 200
            //   7416                 | je                  0x18
            //   80f92f               | cmp                 cl, 0x2f
            //   7411                 | je                  0x13
            //   80f93d               | cmp                 cl, 0x3d
            //   740c                 | je                  0xe
            //   3bc6                 | cmp                 eax, esi
            //   7e04                 | jle                 6

        $sequence_2 = { 7415 3bcb 7611 83fa1f 730c 884415d4 42 }
            // n = 7, score = 200
            //   7415                 | je                  0x17
            //   3bcb                 | cmp                 ecx, ebx
            //   7611                 | jbe                 0x13
            //   83fa1f               | cmp                 edx, 0x1f
            //   730c                 | jae                 0xe
            //   884415d4             | mov                 byte ptr [ebp + edx - 0x2c], al
            //   42                   | inc                 edx

        $sequence_3 = { 8d0409 83f80a 89442410 7e08 c74424100a000000 3b6c243c 0f8cf5fdffff }
            // n = 7, score = 200
            //   8d0409               | lea                 eax, [ecx + ecx]
            //   83f80a               | cmp                 eax, 0xa
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   7e08                 | jle                 0xa
            //   c74424100a000000     | mov                 dword ptr [esp + 0x10], 0xa
            //   3b6c243c             | cmp                 ebp, dword ptr [esp + 0x3c]
            //   0f8cf5fdffff         | jl                  0xfffffdfb

        $sequence_4 = { ff7514 e8???????? 8bf0 59 85f6 7416 ff7514 }
            // n = 7, score = 200
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx
            //   85f6                 | test                esi, esi
            //   7416                 | je                  0x18
            //   ff7514               | push                dword ptr [ebp + 0x14]

        $sequence_5 = { 68???????? 50 68???????? 6a03 e8???????? 83c410 8906 }
            // n = 7, score = 200
            //   68????????           |                     
            //   50                   | push                eax
            //   68????????           |                     
            //   6a03                 | push                3
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8906                 | mov                 dword ptr [esi], eax

        $sequence_6 = { e8???????? 59 5e c3 6a00 56 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   6a00                 | push                0
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_7 = { ff731c 6a09 680b110000 ff35???????? e8???????? 83c410 85c0 }
            // n = 7, score = 200
            //   ff731c               | push                dword ptr [ebx + 0x1c]
            //   6a09                 | push                9
            //   680b110000           | push                0x110b
            //   ff35????????         |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax

        $sequence_8 = { ff742410 ff742410 ff742410 ff742410 ffd0 c3 56 }
            // n = 7, score = 200
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ffd0                 | call                eax
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_9 = { 817e0402020000 0f85c1000000 6af4 ff36 e8???????? 59 59 }
            // n = 7, score = 200
            //   817e0402020000       | cmp                 dword ptr [esi + 4], 0x202
            //   0f85c1000000         | jne                 0xc7
            //   6af4                 | push                -0xc
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 491520
}