rule win_careto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.careto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.careto"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895104 47 ff15???????? eb58 8d45ec 50 8d45f4 }
            // n = 7, score = 100
            //   895104               | mov                 dword ptr [ecx + 4], edx
            //   47                   | inc                 edi
            //   ff15????????         |                     
            //   eb58                 | jmp                 0x5a
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_1 = { eb1e ff7508 8d8568fbffff 50 }
            // n = 4, score = 100
            //   eb1e                 | jmp                 0x20
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d8568fbffff         | lea                 eax, [ebp - 0x498]
            //   50                   | push                eax

        $sequence_2 = { 85c0 0f850e020000 57 6a40 59 889ddcfdffff 8dbdddfdffff }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f850e020000         | jne                 0x214
            //   57                   | push                edi
            //   6a40                 | push                0x40
            //   59                   | pop                 ecx
            //   889ddcfdffff         | mov                 byte ptr [ebp - 0x224], bl
            //   8dbdddfdffff         | lea                 edi, [ebp - 0x223]

        $sequence_3 = { 8b4b04 56 8b7308 8bc1 03f2 3bf0 8945fc }
            // n = 7, score = 100
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   56                   | push                esi
            //   8b7308               | mov                 esi, dword ptr [ebx + 8]
            //   8bc1                 | mov                 eax, ecx
            //   03f2                 | add                 esi, edx
            //   3bf0                 | cmp                 esi, eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_4 = { ff55e0 3bc6 8945e4 740b 3dea000000 0f85fd000000 8b7df4 }
            // n = 7, score = 100
            //   ff55e0               | call                dword ptr [ebp - 0x20]
            //   3bc6                 | cmp                 eax, esi
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   740b                 | je                  0xd
            //   3dea000000           | cmp                 eax, 0xea
            //   0f85fd000000         | jne                 0x103
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]

        $sequence_5 = { 7584 85ff 7407 57 ff15???????? 33c0 40 }
            // n = 7, score = 100
            //   7584                 | jne                 0xffffff86
            //   85ff                 | test                edi, edi
            //   7407                 | je                  9
            //   57                   | push                edi
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_6 = { 8b3d???????? be???????? 7579 ffd7 }
            // n = 4, score = 100
            //   8b3d????????         |                     
            //   be????????           |                     
            //   7579                 | jne                 0x7b
            //   ffd7                 | call                edi

        $sequence_7 = { a0???????? c3 e8???????? 84c0 740c 833d????????05 }
            // n = 6, score = 100
            //   a0????????           |                     
            //   c3                   | ret                 
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   740c                 | je                  0xe
            //   833d????????05       |                     

        $sequence_8 = { 81ecb8080000 53 8b5d08 68???????? 53 c745e8d4070000 e8???????? }
            // n = 7, score = 100
            //   81ecb8080000         | sub                 esp, 0x8b8
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   68????????           |                     
            //   53                   | push                ebx
            //   c745e8d4070000       | mov                 dword ptr [ebp - 0x18], 0x7d4
            //   e8????????           |                     

        $sequence_9 = { 7416 48 740c 83e804 754a 68???????? }
            // n = 6, score = 100
            //   7416                 | je                  0x18
            //   48                   | dec                 eax
            //   740c                 | je                  0xe
            //   83e804               | sub                 eax, 4
            //   754a                 | jne                 0x4c
            //   68????????           |                     

    condition:
        7 of them and filesize < 94208
}