rule win_carrotball_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.carrotball."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.carrotball"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7451 6a00 68???????? ff15???????? }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   7451                 | je                  0x53
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_1 = { 6a20 6a00 68???????? 83f878 751f 68???????? }
            // n = 6, score = 200
            //   6a20                 | push                0x20
            //   6a00                 | push                0
            //   68????????           |                     
            //   83f878               | cmp                 eax, 0x78
            //   751f                 | jne                 0x21
            //   68????????           |                     

        $sequence_2 = { 6a00 6802000080 6a20 6a00 }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   6802000080           | push                0x80000002
            //   6a20                 | push                0x20
            //   6a00                 | push                0

        $sequence_3 = { 85c0 7432 8d85ecfdffff 50 ff15???????? }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   7432                 | je                  0x34
            //   8d85ecfdffff         | lea                 eax, [ebp - 0x214]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { 68???????? ff15???????? eb36 68???????? 56 }
            // n = 5, score = 200
            //   68????????           |                     
            //   ff15????????         |                     
            //   eb36                 | jmp                 0x38
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_5 = { 8d85f4fdffff 50 c785ecfdffff00000000 ff15???????? }
            // n = 4, score = 200
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax
            //   c785ecfdffff00000000     | mov    dword ptr [ebp - 0x214], 0
            //   ff15????????         |                     

        $sequence_6 = { 85c0 0f84f5000000 57 6a00 6a00 }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   0f84f5000000         | je                  0xfb
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_7 = { 85c0 7451 6a00 68???????? ff15???????? eb36 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7451                 | je                  0x53
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   eb36                 | jmp                 0x38

        $sequence_8 = { 0f84f5000000 57 6a00 6a00 }
            // n = 4, score = 200
            //   0f84f5000000         | je                  0xfb
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_9 = { 6a04 58 6bc000 c7807430001002000000 6a04 58 6bc000 }
            // n = 7, score = 200
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   c7807430001002000000     | mov    dword ptr [eax + 0x10003074], 2
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0

    condition:
        7 of them and filesize < 40960
}