rule win_casper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.casper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.casper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 59 8d4df8 51 6a01 50 6801000080 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   6a01                 | push                1
            //   50                   | push                eax
            //   6801000080           | push                0x80000001

        $sequence_1 = { 88471c 8a4626 88471d 8b4624 59 c1e808 59 }
            // n = 7, score = 100
            //   88471c               | mov                 byte ptr [edi + 0x1c], al
            //   8a4626               | mov                 al, byte ptr [esi + 0x26]
            //   88471d               | mov                 byte ptr [edi + 0x1d], al
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   59                   | pop                 ecx
            //   c1e808               | shr                 eax, 8
            //   59                   | pop                 ecx

        $sequence_2 = { 83c40c ff7010 8d8560fdffff 68???????? 50 }
            // n = 5, score = 100
            //   83c40c               | add                 esp, 0xc
            //   ff7010               | push                dword ptr [eax + 0x10]
            //   8d8560fdffff         | lea                 eax, [ebp - 0x2a0]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_3 = { 832600 83661400 894608 c7461000100000 e8???????? 8945fc a1???????? }
            // n = 7, score = 100
            //   832600               | and                 dword ptr [esi], 0
            //   83661400             | and                 dword ptr [esi + 0x14], 0
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   c7461000100000       | mov                 dword ptr [esi + 0x10], 0x1000
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   a1????????           |                     

        $sequence_4 = { 8d8500ffffff 50 ff7510 e8???????? 83c410 8d8500ffffff 50 }
            // n = 7, score = 100
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]
            //   50                   | push                eax
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]
            //   50                   | push                eax

        $sequence_5 = { 897808 eb02 33c0 8930 897804 8b4b10 }
            // n = 6, score = 100
            //   897808               | mov                 dword ptr [eax + 8], edi
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8930                 | mov                 dword ptr [eax], esi
            //   897804               | mov                 dword ptr [eax + 4], edi
            //   8b4b10               | mov                 ecx, dword ptr [ebx + 0x10]

        $sequence_6 = { 5e 40 5b c9 c21000 8b8118010000 c3 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   40                   | inc                 eax
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c21000               | ret                 0x10
            //   8b8118010000         | mov                 eax, dword ptr [ecx + 0x118]
            //   c3                   | ret                 

        $sequence_7 = { 8a01 84c0 75f1 8b4d08 52 ff7510 }
            // n = 6, score = 100
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   84c0                 | test                al, al
            //   75f1                 | jne                 0xfffffff3
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_8 = { 81e200008000 52 57 57 57 ff75a8 ff34850ca14200 }
            // n = 7, score = 100
            //   81e200008000         | and                 edx, 0x800000
            //   52                   | push                edx
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   ff75a8               | push                dword ptr [ebp - 0x58]
            //   ff34850ca14200       | push                dword ptr [eax*4 + 0x42a10c]

        $sequence_9 = { 2bc6 03450c 50 ff7508 e8???????? }
            // n = 5, score = 100
            //   2bc6                 | sub                 eax, esi
            //   03450c               | add                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 434176
}