rule win_ccleaner_backdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ccleaner_backdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ccleaner_backdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd6 50 ff15???????? 8b3d???????? 59 ffd7 }
            // n = 6, score = 200
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   59                   | pop                 ecx
            //   ffd7                 | call                edi

        $sequence_1 = { 8a11 305103 8b480c 8b09 8a5101 }
            // n = 5, score = 100
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   305103               | xor                 byte ptr [ecx + 3], dl
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   8a5101               | mov                 dl, byte ptr [ecx + 1]

        $sequence_2 = { 03c6 85c0 7f09 488b0a 488b01 ff5008 488b4b28 }
            // n = 7, score = 100
            //   03c6                 | mov                 esi, dword ptr [ebx + 0x40]
            //   85c0                 | inc                 ecx
            //   7f09                 | mov                 eax, esp
            //   488b0a               | add                 eax, eax
            //   488b01               | mov                 dword ptr [ebx + 0x40], eax
            //   ff5008               | mov                 esi, dword ptr [ebx + 0x40]
            //   488b4b28             | inc                 ecx

        $sequence_3 = { 01442424 eb30 8b4508 897518 }
            // n = 4, score = 100
            //   01442424             | mov                 esi, dword ptr [ebp + 8]
            //   eb30                 | mov                 edx, dword ptr [ebp + 0x10]
            //   8b4508               | add                 eax, esi
            //   897518               | add                 eax, 0x100

        $sequence_4 = { 8d856cffffff 6a0c 50 c7856cffffff11618a64 c78570ffffff470de38d c78574ffffff27defaf2 e8???????? }
            // n = 7, score = 100
            //   8d856cffffff         | lea                 eax, [ebp - 0x94]
            //   6a0c                 | push                0xc
            //   50                   | push                eax
            //   c7856cffffff11618a64     | mov    dword ptr [ebp - 0x94], 0x648a6111
            //   c78570ffffff470de38d     | mov    dword ptr [ebp - 0x90], 0x8de30d47
            //   c78574ffffff27defaf2     | mov    dword ptr [ebp - 0x8c], 0xf2fade27
            //   e8????????           |                     

        $sequence_5 = { 013e 33c0 8b16 83c410 }
            // n = 4, score = 100
            //   013e                 | push                eax
            //   33c0                 | pop                 ecx
            //   8b16                 | pop                 ecx
            //   83c410               | call                edi

        $sequence_6 = { 03c6 4863d0 4c8d0c12 4c8d4718 }
            // n = 4, score = 100
            //   03c6                 | sub                 esp, 0x20
            //   4863d0               | add                 esp, ecx
            //   4c8d0c12             | int3                
            //   4c8d4718             | dec                 eax

        $sequence_7 = { 33f6 6a1c 8d45e4 59 c60000 }
            // n = 5, score = 100
            //   33f6                 | dec                 eax
            //   6a1c                 | mov                 eax, dword ptr [ecx]
            //   8d45e4               | call                dword ptr [eax + 8]
            //   59                   | dec                 eax
            //   c60000               | mov                 edx, dword ptr [ebx + 0x48]

        $sequence_8 = { 01cc cc 48895c2408 57 }
            // n = 4, score = 100
            //   01cc                 | sub                 edx, 0x18
            //   cc                   | or                  eax, 0xffffffff
            //   48895c2408           | lock xadd           dword ptr [edx + 0x10], eax
            //   57                   | add                 dword ptr [esi + 0xc], eax

        $sequence_9 = { 03c0 894340 8b7340 418bc4 }
            // n = 4, score = 100
            //   03c0                 | xor                 eax, eax
            //   894340               | jmp                 0x12
            //   8b7340               | add                 dword ptr [esi + 0xc], eax
            //   418bc4               | dec                 eax

        $sequence_10 = { 83c410 8d85fcfeffff 50 ff15???????? be00010000 }
            // n = 5, score = 100
            //   83c410               | add                 esp, 0x10
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   be00010000           | mov                 esi, 0x100

        $sequence_11 = { 8b450c 53 56 8b7508 8b5510 03c6 }
            // n = 6, score = 100
            //   8b450c               | dec                 eax
            //   53                   | arpl                ax, cx
            //   56                   | dec                 eax
            //   8b7508               | lea                 ebx, [ebx + ecx*2]
            //   8b5510               | dec                 ecx
            //   03c6                 | cmp                 ebx, esp

        $sequence_12 = { 03cd 41 8a01 4c 03cd 8802 }
            // n = 6, score = 100
            //   03cd                 | jg                  0xd
            //   41                   | dec                 eax
            //   8a01                 | mov                 ecx, dword ptr [edx]
            //   4c                   | dec                 eax
            //   03cd                 | mov                 eax, dword ptr [ecx]
            //   8802                 | call                dword ptr [eax + 8]

        $sequence_13 = { 6844494e00 e8???????? 8365e400 8945e0 8d4508 6a04 }
            // n = 6, score = 100
            //   6844494e00           | push                0x4e4944
            //   e8????????           |                     
            //   8365e400             | and                 dword ptr [ebp - 0x1c], 0
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d4508               | lea                 eax, [ebp + 8]
            //   6a04                 | push                4

        $sequence_14 = { 83e805 743a 48 7409 }
            // n = 4, score = 100
            //   83e805               | add                 eax, esi
            //   743a                 | test                eax, eax
            //   48                   | jg                  0xd
            //   7409                 | dec                 eax

        $sequence_15 = { 7507 33c0 e9???????? e8???????? 6800000100 6a40 }
            // n = 6, score = 100
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   e8????????           |                     
            //   6800000100           | push                0x10000
            //   6a40                 | push                0x40

        $sequence_16 = { 01442454 03d1 294c2450 8b4c2410 }
            // n = 4, score = 100
            //   01442454             | pop                 ebp
            //   03d1                 | pop                 ebx
            //   294c2450             | add                 dword ptr [esi], ebp
            //   8b4c2410             | xor                 eax, eax

        $sequence_17 = { 01460c 488b3f 493bfc 0f8554ffffff }
            // n = 4, score = 100
            //   01460c               | dec                 eax
            //   488b3f               | sub                 esp, 0x28
            //   493bfc               | dec                 eax
            //   0f8554ffffff         | mov                 edx, dword ptr [ecx]

        $sequence_18 = { 01461c 8b542424 85d2 7405 }
            // n = 4, score = 100
            //   01461c               | add                 eax, 0x800
            //   8b542424             | cmp                 ecx, eax
            //   85d2                 | jae                 0x28
            //   7405                 | mov                 word ptr [ecx + 4], 0xa00

        $sequence_19 = { 0fb645f8 50 8d45d8 50 }
            // n = 4, score = 100
            //   0fb645f8             | movzx               eax, byte ptr [ebp - 8]
            //   50                   | push                eax
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax

        $sequence_20 = { 012e 33c0 5f 5e }
            // n = 4, score = 100
            //   012e                 | cmp                 ebx, esp
            //   33c0                 | jb                  0xffffffd8
            //   5f                   | add                 eax, edi
            //   5e                   | dec                 eax

        $sequence_21 = { 00cc cc 4057 4883ec50 }
            // n = 4, score = 100
            //   00cc                 | add                 ah, cl
            //   cc                   | int3                
            //   4057                 | inc                 eax
            //   4883ec50             | push                edi

        $sequence_22 = { 03c7 4863c8 488d1c4b 493bdc }
            // n = 4, score = 100
            //   03c7                 | add                 eax, esi
            //   4863c8               | dec                 eax
            //   488d1c4b             | arpl                ax, dx
            //   493bdc               | dec                 esp

        $sequence_23 = { 42 47 8a07 8802 8a4701 42 8802 }
            // n = 7, score = 100
            //   42                   | dec                 eax
            //   47                   | mov                 edx, dword ptr [ebx + 0x40]
            //   8a07                 | add                 eax, esi
            //   8802                 | test                eax, eax
            //   8a4701               | jg                  0xd
            //   42                   | dec                 eax
            //   8802                 | mov                 ecx, dword ptr [edx]

        $sequence_24 = { 014c2464 40 89542418 89442430 }
            // n = 4, score = 100
            //   014c2464             | mov                 edx, dword ptr [esi]
            //   40                   | add                 esp, 0x10
            //   89542418             | mov                 ecx, dword ptr [esi + 8]
            //   89442430             | inc                 eax

        $sequence_25 = { ff15???????? 46 83fe3c 7cd0 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   46                   | mov                 ecx, dword ptr [edx]
            //   83fe3c               | dec                 eax
            //   7cd0                 | mov                 eax, dword ptr [ecx]

        $sequence_26 = { 50 56 e8???????? 8b45f8 bfa0010000 c1e008 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   bfa0010000           | mov                 edi, 0x1a0
            //   c1e008               | shl                 eax, 8

        $sequence_27 = { 01442418 03c8 8954242c 8b542470 }
            // n = 4, score = 100
            //   01442418             | mov                 al, byte ptr [edi + 1]
            //   03c8                 | inc                 edx
            //   8954242c             | mov                 byte ptr [edx], al
            //   8b542470             | xor                 esi, esi

        $sequence_28 = { 00cc cc 4883ec28 488b11 }
            // n = 4, score = 100
            //   00cc                 | dec                 esp
            //   cc                   | mov                 edx, ecx
            //   4883ec28             | add                 ah, cl
            //   488b11               | int3                

        $sequence_29 = { 8bd1 49 8bd0 41 }
            // n = 4, score = 100
            //   8bd1                 | call                dword ptr [eax + 8]
            //   49                   | dec                 eax
            //   8bd0                 | mov                 edx, dword ptr [ebx + 0x50]
            //   41                   | add                 eax, edi

        $sequence_30 = { 013d???????? 8b04b5d8970210 0500080000 3bc8 }
            // n = 4, score = 100
            //   013d????????         |                     
            //   8b04b5d8970210       | dec                 edx
            //   0500080000           | lea                 ebx, [eax + ebp*2]
            //   3bc8                 | dec                 eax

    condition:
        7 of them and filesize < 377856
}