rule win_cerber_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cerber."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cerber"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8345fc04 8901 ff45f8 8b45f8 }
            // n = 4, score = 1200
            //   8345fc04             | add                 dword ptr [ebp - 4], 4
            //   8901                 | mov                 dword ptr [ecx], eax
            //   ff45f8               | inc                 dword ptr [ebp - 8]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_1 = { 8b5508 2bd7 8955f4 8975fc }
            // n = 4, score = 1200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   2bd7                 | sub                 edx, edi
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi

        $sequence_2 = { 59 84c0 7413 8b450c 56 ff7508 8b7510 }
            // n = 7, score = 1200
            //   59                   | pop                 ecx
            //   84c0                 | test                al, al
            //   7413                 | je                  0x15
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]

        $sequence_3 = { 833c8100 7505 85c0 75f1 c3 40 }
            // n = 6, score = 1200
            //   833c8100             | cmp                 dword ptr [ecx + eax*4], 0
            //   7505                 | jne                 7
            //   85c0                 | test                eax, eax
            //   75f1                 | jne                 0xfffffff3
            //   c3                   | ret                 
            //   40                   | inc                 eax

        $sequence_4 = { 8b550c 8b4510 b900100000 2b8e7c3b0000 33db 2b55fc 1bc3 }
            // n = 7, score = 1200
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   b900100000           | mov                 ecx, 0x1000
            //   2b8e7c3b0000         | sub                 ecx, dword ptr [esi + 0x3b7c]
            //   33db                 | xor                 ebx, ebx
            //   2b55fc               | sub                 edx, dword ptr [ebp - 4]
            //   1bc3                 | sbb                 eax, ebx

        $sequence_5 = { 7709 39450c 0f86dc000000 8b550c 8b4510 }
            // n = 5, score = 1200
            //   7709                 | ja                  0xb
            //   39450c               | cmp                 dword ptr [ebp + 0xc], eax
            //   0f86dc000000         | jbe                 0xe2
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_6 = { 6a00 50 e8???????? 8b4df0 83c40c 85c9 7e58 }
            // n = 7, score = 1200
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c40c               | add                 esp, 0xc
            //   85c9                 | test                ecx, ecx
            //   7e58                 | jle                 0x5a

        $sequence_7 = { 7433 8b7d0c 8b5508 2bd7 8955f4 8975fc }
            // n = 6, score = 1200
            //   7433                 | je                  0x35
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   2bd7                 | sub                 edx, edi
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi

        $sequence_8 = { 762e 85d2 7838 8b4508 8b04b8 83651400 837d1420 }
            // n = 7, score = 1200
            //   762e                 | jbe                 0x30
            //   85d2                 | test                edx, edx
            //   7838                 | js                  0x3a
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b04b8               | mov                 eax, dword ptr [eax + edi*4]
            //   83651400             | and                 dword ptr [ebp + 0x14], 0
            //   837d1420             | cmp                 dword ptr [ebp + 0x14], 0x20

        $sequence_9 = { 3b7d0c 72d2 85d2 780a }
            // n = 4, score = 1200
            //   3b7d0c               | cmp                 edi, dword ptr [ebp + 0xc]
            //   72d2                 | jb                  0xffffffd4
            //   85d2                 | test                edx, edx
            //   780a                 | js                  0xc

    condition:
        7 of them and filesize < 573440
}