rule win_chairsmack_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chairsmack."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chairsmack"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a01 41 84c0 75f9 2b4dac 8d450c 6a00 }
            // n = 7, score = 200
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   41                   | inc                 ecx
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   2b4dac               | sub                 ecx, dword ptr [ebp - 0x54]
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   6a00                 | push                0

        $sequence_1 = { c7462000000000 c7462400000000 c7462800000000 c7462c00000000 e8???????? 6819020000 68???????? }
            // n = 7, score = 200
            //   c7462000000000       | mov                 dword ptr [esi + 0x20], 0
            //   c7462400000000       | mov                 dword ptr [esi + 0x24], 0
            //   c7462800000000       | mov                 dword ptr [esi + 0x28], 0
            //   c7462c00000000       | mov                 dword ptr [esi + 0x2c], 0
            //   e8????????           |                     
            //   6819020000           | push                0x219
            //   68????????           |                     

        $sequence_2 = { 8d44241c 50 e8???????? 50 c684248c00000002 e8???????? }
            // n = 6, score = 200
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   50                   | push                eax
            //   c684248c00000002     | mov                 byte ptr [esp + 0x8c], 2
            //   e8????????           |                     

        $sequence_3 = { 8b8dd0fdffff 83e11f c1e106 030c85d06d4a00 898d30fdffff eb0a c78530fdffff78474a00 }
            // n = 7, score = 200
            //   8b8dd0fdffff         | mov                 ecx, dword ptr [ebp - 0x230]
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   030c85d06d4a00       | add                 ecx, dword ptr [eax*4 + 0x4a6dd0]
            //   898d30fdffff         | mov                 dword ptr [ebp - 0x2d0], ecx
            //   eb0a                 | jmp                 0xc
            //   c78530fdffff78474a00     | mov    dword ptr [ebp - 0x2d0], 0x4a4778

        $sequence_4 = { 50 e8???????? 83c404 8d8580feffff 68b8000000 6a00 50 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d8580feffff         | lea                 eax, [ebp - 0x180]
            //   68b8000000           | push                0xb8
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_5 = { 68???????? e8???????? 83ec1c c68424b80300009f 8bcc 68???????? e8???????? }
            // n = 7, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   83ec1c               | sub                 esp, 0x1c
            //   c68424b80300009f     | mov                 byte ptr [esp + 0x3b8], 0x9f
            //   8bcc                 | mov                 ecx, esp
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_6 = { 837dc800 7526 68???????? 68???????? 6a00 68de000000 68???????? }
            // n = 7, score = 200
            //   837dc800             | cmp                 dword ptr [ebp - 0x38], 0
            //   7526                 | jne                 0x28
            //   68????????           |                     
            //   68????????           |                     
            //   6a00                 | push                0
            //   68de000000           | push                0xde
            //   68????????           |                     

        $sequence_7 = { ff15???????? 8b4d08 8b148dcc504a00 83e202 740d 8d85e4dfffff 50 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b148dcc504a00       | mov                 edx, dword ptr [ecx*4 + 0x4a50cc]
            //   83e202               | and                 edx, 2
            //   740d                 | je                  0xf
            //   8d85e4dfffff         | lea                 eax, [ebp - 0x201c]
            //   50                   | push                eax

        $sequence_8 = { 0fb745ec eb5a 8d45ec 8d4dc8 3945c0 7579 8d4594 }
            // n = 7, score = 200
            //   0fb745ec             | movzx               eax, word ptr [ebp - 0x14]
            //   eb5a                 | jmp                 0x5c
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   3945c0               | cmp                 dword ptr [ebp - 0x40], eax
            //   7579                 | jne                 0x7b
            //   8d4594               | lea                 eax, [ebp - 0x6c]

        $sequence_9 = { 7207 8b16 895518 eb03 897518 83f810 7204 }
            // n = 7, score = 200
            //   7207                 | jb                  9
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   895518               | mov                 dword ptr [ebp + 0x18], edx
            //   eb03                 | jmp                 5
            //   897518               | mov                 dword ptr [ebp + 0x18], esi
            //   83f810               | cmp                 eax, 0x10
            //   7204                 | jb                  6

    condition:
        7 of them and filesize < 1974272
}