rule win_charon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.charon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.charon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4c2420 8d0c8d01000000 4863c9 88440c50 b803000000 2b442420 4898 }
            // n = 7, score = 100
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x19c]
            //   8d0c8d01000000       | mov                 edx, dword ptr [esp + 0x1a0]
            //   4863c9               | add                 eax, 0x205
            //   88440c50             | mov                 eax, eax
            //   b803000000           | dec                 eax
            //   2b442420             | mov                 ecx, dword ptr [esp + 0x260]
            //   4898                 | mov                 eax, dword ptr [ecx + eax*4]

        $sequence_1 = { 050b020000 8bc0 488b8c2460020000 8b0481 038424f8010000 8b8c24fc010000 8b942400020000 }
            // n = 7, score = 100
            //   050b020000           | dec                 eax
            //   8bc0                 | mov                 dword ptr [esp + 0x20], 0
            //   488b8c2460020000     | dec                 esp
            //   8b0481               | lea                 ecx, [esp + 0x80]
            //   038424f8010000       | inc                 esp
            //   8b8c24fc010000       | mov                 eax, eax
            //   8b942400020000       | dec                 eax

        $sequence_2 = { 480bc1 48c1f802 4825ffffff01 b908000000 486bc901 488b542408 }
            // n = 6, score = 100
            //   480bc1               | inc                 eax
            //   48c1f802             | mov                 dword ptr [esp + 0x44], eax
            //   4825ffffff01         | mov                 eax, dword ptr [esp + 0xa4]
            //   b908000000           | cmp                 dword ptr [esp + 0x44], eax
            //   486bc901             | mov                 eax, dword ptr [esp + 0x44]
            //   488b542408           | inc                 eax

        $sequence_3 = { 486bc000 488b8c2460020000 8b840140100000 c1e00a b904000000 486bc900 488b942460020000 }
            // n = 7, score = 100
            //   486bc000             | test                eax, eax
            //   488b8c2460020000     | je                  0xa19
            //   8b840140100000       | dec                 eax
            //   c1e00a               | lea                 edx, [0xffff81bc]
            //   b904000000           | dec                 eax
            //   486bc900             | lea                 ecx, [esp + 0x70]
            //   488b942460020000     | dec                 eax

        $sequence_4 = { 48c1e108 480bc1 b901000000 486bc90e 488b542410 0fb60c0a 48c1e110 }
            // n = 7, score = 100
            //   48c1e108             | mov                 eax, ecx
            //   480bc1               | mov                 ecx, dword ptr [esp]
            //   b901000000           | add                 ecx, 0xd
            //   486bc90e             | mov                 ecx, ecx
            //   488b542410           | dec                 eax
            //   0fb60c0a             | mov                 edx, dword ptr [esp + 0x260]
            //   48c1e110             | add                 eax, dword ptr [edx + ecx*4]

        $sequence_5 = { c784249c00000000000000 8b0424 8b4c2408 03c8 }
            // n = 4, score = 100
            //   c784249c00000000000000     | mov    ecx, dword ptr [esp + 0x260]
            //   8b0424               | mov                 eax, dword ptr [esp + 0x44]
            //   8b4c2408             | cmp                 dword ptr [esp + 0xc], eax
            //   03c8                 | jae                 0x137d

        $sequence_6 = { 488b942460020000 8b8c0a40100000 c1e916 0bc1 898424d8010000 b804000000 486bc00f }
            // n = 7, score = 100
            //   488b942460020000     | mov                 eax, dword ptr [esp + 0x7c]
            //   8b8c0a40100000       | mov                 ecx, dword ptr [esp + 0x84]
            //   c1e916               | xor                 ecx, eax
            //   0bc1                 | mov                 eax, dword ptr [esp + eax*8 + 0x1a0]
            //   898424d8010000       | shr                 eax, 8
            //   b804000000           | mov                 ecx, dword ptr [esp + 0x18]
            //   486bc00f             | sub                 ecx, 0xf

        $sequence_7 = { 050f020000 8bc0 488b8c2460020000 8b0481 03842438020000 8b8c243c020000 8b942440020000 }
            // n = 7, score = 100
            //   050f020000           | lea                 edx, [0xffff8984]
            //   8bc0                 | dec                 eax
            //   488b8c2460020000     | mov                 ecx, dword ptr [esp + 0x48]
            //   8b0481               | dec                 eax
            //   03842438020000       | lea                 edx, [esp + 0x90]
            //   8b8c243c020000       | dec                 eax
            //   8b942440020000       | mov                 ecx, dword ptr [esp + 0x48]

        $sequence_8 = { 0bc1 89442448 b804000000 486bc004 488b8c2460020000 0fb6840100100000 88442443 }
            // n = 7, score = 100
            //   0bc1                 | lea                 ecx, [esp + 0x70]
            //   89442448             | dec                 eax
            //   b804000000           | mov                 edx, dword ptr [esp + 0x150]
            //   486bc004             | dec                 eax
            //   488b8c2460020000     | lea                 ecx, [esp + 0x70]
            //   0fb6840100100000     | dec                 eax
            //   88442443             | lea                 edx, [0xffff819f]

        $sequence_9 = { 48c744243000000000 8b8424c0000000 89442428 488b842430010000 4889442420 448b8c24f0000000 }
            // n = 6, score = 100
            //   48c744243000000000     | dec    eax
            //   8b8424c0000000       | imul                eax, eax, 0
            //   89442428             | test                eax, eax
            //   488b842430010000     | je                  0x1145
            //   4889442420           | cmp                 dword ptr [esp + 0x6c], 1
            //   448b8c24f0000000     | je                  0x1145

    condition:
        7 of them and filesize < 254976
}