rule win_chches_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chches."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chches"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b4c243c 8903 8b4534 83c408 85c0 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8b4c243c             | mov                 ecx, dword ptr [esp + 0x3c]
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8b4534               | mov                 eax, dword ptr [ebp + 0x34]
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax

        $sequence_1 = { ffd2 3dfe1f0000 7608 83eb64 e9???????? 8b7c2454 }
            // n = 6, score = 200
            //   ffd2                 | call                edx
            //   3dfe1f0000           | cmp                 eax, 0x1ffe
            //   7608                 | jbe                 0xa
            //   83eb64               | sub                 ebx, 0x64
            //   e9????????           |                     
            //   8b7c2454             | mov                 edi, dword ptr [esp + 0x54]

        $sequence_2 = { 03c1 50 57 e8???????? 8b96d8000000 83c408 6860ea0000 }
            // n = 7, score = 200
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   8b96d8000000         | mov                 edx, dword ptr [esi + 0xd8]
            //   83c408               | add                 esp, 8
            //   6860ea0000           | push                0xea60

        $sequence_3 = { c7460800000000 8b4744 56 6a00 ffd0 8b4f50 50 }
            // n = 7, score = 200
            //   c7460800000000       | mov                 dword ptr [esi + 8], 0
            //   8b4744               | mov                 eax, dword ptr [edi + 0x44]
            //   56                   | push                esi
            //   6a00                 | push                0
            //   ffd0                 | call                eax
            //   8b4f50               | mov                 ecx, dword ptr [edi + 0x50]
            //   50                   | push                eax

        $sequence_4 = { 897c2424 897c2430 3bc7 0f856c020000 8b5d0c 3bdf 0f8404030000 }
            // n = 7, score = 200
            //   897c2424             | mov                 dword ptr [esp + 0x24], edi
            //   897c2430             | mov                 dword ptr [esp + 0x30], edi
            //   3bc7                 | cmp                 eax, edi
            //   0f856c020000         | jne                 0x272
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   3bdf                 | cmp                 ebx, edi
            //   0f8404030000         | je                  0x30a

        $sequence_5 = { 0f84aa010000 8b4660 8bd1 52 ffd0 8b5644 8bd8 }
            // n = 7, score = 200
            //   0f84aa010000         | je                  0x1b0
            //   8b4660               | mov                 eax, dword ptr [esi + 0x60]
            //   8bd1                 | mov                 edx, ecx
            //   52                   | push                edx
            //   ffd0                 | call                eax
            //   8b5644               | mov                 edx, dword ptr [esi + 0x44]
            //   8bd8                 | mov                 ebx, eax

        $sequence_6 = { 8d791c 81c61d051101 85ff 746e 85db 744d 8b550c }
            // n = 7, score = 200
            //   8d791c               | lea                 edi, [ecx + 0x1c]
            //   81c61d051101         | add                 esi, 0x111051d
            //   85ff                 | test                edi, edi
            //   746e                 | je                  0x70
            //   85db                 | test                ebx, ebx
            //   744d                 | je                  0x4f
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_7 = { 50 8b4364 ffd0 8b4df8 8b938c000000 6a00 6a00 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8b4364               | mov                 eax, dword ptr [ebx + 0x64]
            //   ffd0                 | call                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b938c000000         | mov                 edx, dword ptr [ebx + 0x8c]
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { 33d2 6689140f 8b7c2410 eb1e 85c0 751a 8b03 }
            // n = 7, score = 200
            //   33d2                 | xor                 edx, edx
            //   6689140f             | mov                 word ptr [edi + ecx], dx
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   eb1e                 | jmp                 0x20
            //   85c0                 | test                eax, eax
            //   751a                 | jne                 0x1c
            //   8b03                 | mov                 eax, dword ptr [ebx]

        $sequence_9 = { ffd2 50 8b4650 ffd0 8b4dfc 51 8d7df8 }
            // n = 7, score = 200
            //   ffd2                 | call                edx
            //   50                   | push                eax
            //   8b4650               | mov                 eax, dword ptr [esi + 0x50]
            //   ffd0                 | call                eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   8d7df8               | lea                 edi, [ebp - 8]

    condition:
        7 of them and filesize < 122880
}