rule win_cheesetray_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cheesetray."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cheesetray"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83b8a400000000 894d10 7666 8b88a0000000 8b0419 03cb 85c0 }
            // n = 7, score = 200
            //   83b8a400000000       | cmp                 dword ptr [eax + 0xa4], 0
            //   894d10               | mov                 dword ptr [ebp + 0x10], ecx
            //   7666                 | jbe                 0x68
            //   8b88a0000000         | mov                 ecx, dword ptr [eax + 0xa0]
            //   8b0419               | mov                 eax, dword ptr [ecx + ebx]
            //   03cb                 | add                 ecx, ebx
            //   85c0                 | test                eax, eax

        $sequence_1 = { 8b0c8d80ce4400 83e01f c1e006 8d440124 8b4d10 8a10 }
            // n = 6, score = 200
            //   8b0c8d80ce4400       | mov                 ecx, dword ptr [ecx*4 + 0x44ce80]
            //   83e01f               | and                 eax, 0x1f
            //   c1e006               | shl                 eax, 6
            //   8d440124             | lea                 eax, [ecx + eax + 0x24]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8a10                 | mov                 dl, byte ptr [eax]

        $sequence_2 = { 75f7 03c0 50 8d4dfc 51 52 e8???????? }
            // n = 7, score = 200
            //   75f7                 | jne                 0xfffffff9
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_3 = { 8b8c24a4000000 83c40c 6a02 51 68???????? ba1f000000 }
            // n = 6, score = 200
            //   8b8c24a4000000       | mov                 ecx, dword ptr [esp + 0xa4]
            //   83c40c               | add                 esp, 0xc
            //   6a02                 | push                2
            //   51                   | push                ecx
            //   68????????           |                     
            //   ba1f000000           | mov                 edx, 0x1f

        $sequence_4 = { 81ec84000000 56 6880000000 6a00 8d4580 50 e8???????? }
            // n = 7, score = 200
            //   81ec84000000         | sub                 esp, 0x84
            //   56                   | push                esi
            //   6880000000           | push                0x80
            //   6a00                 | push                0
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 56 6800100000 6a03 56 6a03 6800000080 57 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   6800100000           | push                0x1000
            //   6a03                 | push                3
            //   56                   | push                esi
            //   6a03                 | push                3
            //   6800000080           | push                0x80000000
            //   57                   | push                edi

        $sequence_6 = { 8b5318 52 e8???????? 8b4314 50 e8???????? 83c414 }
            // n = 7, score = 200
            //   8b5318               | mov                 edx, dword ptr [ebx + 0x18]
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_7 = { 40 8945fc 3b85f8feffff 72ad 8b4508 6a00 6a00 }
            // n = 7, score = 200
            //   40                   | inc                 eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   3b85f8feffff         | cmp                 eax, dword ptr [ebp - 0x108]
            //   72ad                 | jb                  0xffffffaf
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { 720e 8b4c2410 3b4c2420 0f83b1000000 8b3d???????? 8d9b00000000 68ff1f0000 }
            // n = 7, score = 200
            //   720e                 | jb                  0x10
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   3b4c2420             | cmp                 ecx, dword ptr [esp + 0x20]
            //   0f83b1000000         | jae                 0xb7
            //   8b3d????????         |                     
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   68ff1f0000           | push                0x1fff

        $sequence_9 = { 8d4df4 51 56 e8???????? 6a04 8d9594fdffff }
            // n = 6, score = 200
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   e8????????           |                     
            //   6a04                 | push                4
            //   8d9594fdffff         | lea                 edx, [ebp - 0x26c]

    condition:
        7 of them and filesize < 8626176
}