rule win_chewbacca_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chewbacca."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chewbacca"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? b909000000 89ee 8b7c2430 f3a6 0f8558010000 89c6 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b909000000           | mov                 ecx, 9
            //   89ee                 | mov                 esi, ebp
            //   8b7c2430             | mov                 edi, dword ptr [esp + 0x30]
            //   f3a6                 | repe cmpsb          byte ptr [esi], byte ptr es:[edi]
            //   0f8558010000         | jne                 0x15e
            //   89c6                 | mov                 esi, eax

        $sequence_1 = { e8???????? c7442414c4796800 c7442410cd846800 c744240c1c070000 89442408 c7442404???????? a1???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c7442414c4796800     | mov                 dword ptr [esp + 0x14], 0x6879c4
            //   c7442410cd846800     | mov                 dword ptr [esp + 0x10], 0x6884cd
            //   c744240c1c070000     | mov                 dword ptr [esp + 0xc], 0x71c
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c7442404????????     |                     
            //   a1????????           |                     

        $sequence_2 = { 8b4324 85c0 7461 c744240c00000000 8d54242c 89542408 c744240400000000 }
            // n = 7, score = 100
            //   8b4324               | mov                 eax, dword ptr [ebx + 0x24]
            //   85c0                 | test                eax, eax
            //   7461                 | je                  0x63
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0
            //   8d54242c             | lea                 edx, [esp + 0x2c]
            //   89542408             | mov                 dword ptr [esp + 8], edx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0

        $sequence_3 = { e9???????? 8b45fc e8???????? 52 50 8d45b8 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   e8????????           |                     

        $sequence_4 = { e8???????? c744241cd4686500 c7442418a0836500 c74424147b110000 89442410 c744240c44446500 c7442408???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c744241cd4686500     | mov                 dword ptr [esp + 0x1c], 0x6568d4
            //   c7442418a0836500     | mov                 dword ptr [esp + 0x18], 0x6583a0
            //   c74424147b110000     | mov                 dword ptr [esp + 0x14], 0x117b
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   c744240c44446500     | mov                 dword ptr [esp + 0xc], 0x654444
            //   c7442408????????     |                     

        $sequence_5 = { e8???????? c7042401000000 e8???????? e8???????? 89c3 e8???????? 895c2410 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c7042401000000       | mov                 dword ptr [esp], 1
            //   e8????????           |                     
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   e8????????           |                     
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx

        $sequence_6 = { e8???????? e8???????? 50 85c0 0f8540040000 b801000000 8d5584 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   85c0                 | test                eax, eax
            //   0f8540040000         | jne                 0x446
            //   b801000000           | mov                 eax, 1
            //   8d5584               | lea                 edx, [ebp - 0x7c]

        $sequence_7 = { e8???????? c744241c84006700 c7442418b7026700 c7442414eb010000 89442410 c744240c64fd6600 c7442408???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c744241c84006700     | mov                 dword ptr [esp + 0x1c], 0x670084
            //   c7442418b7026700     | mov                 dword ptr [esp + 0x18], 0x6702b7
            //   c7442414eb010000     | mov                 dword ptr [esp + 0x14], 0x1eb
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   c744240c64fd6600     | mov                 dword ptr [esp + 0xc], 0x66fd64
            //   c7442408????????     |                     

        $sequence_8 = { e8???????? e8???????? 50 85c0 7516 8d55d4 89d8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   85c0                 | test                eax, eax
            //   7516                 | jne                 0x18
            //   8d55d4               | lea                 edx, [ebp - 0x2c]
            //   89d8                 | mov                 eax, ebx

        $sequence_9 = { e8???????? c7442414cb246800 c7442410f3296800 c744240cec040000 89442408 c7442404???????? a1???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c7442414cb246800     | mov                 dword ptr [esp + 0x14], 0x6824cb
            //   c7442410f3296800     | mov                 dword ptr [esp + 0x10], 0x6829f3
            //   c744240cec040000     | mov                 dword ptr [esp + 0xc], 0x4ec
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c7442404????????     |                     
            //   a1????????           |                     

    condition:
        7 of them and filesize < 9764864
}