rule win_chinad_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chinad."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chinad"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0facde15 83c007 c1fb15 50 89b574ffffff 899d44ffffff e8???????? }
            // n = 7, score = 200
            //   0facde15             | shrd                esi, ebx, 0x15
            //   83c007               | add                 eax, 7
            //   c1fb15               | sar                 ebx, 0x15
            //   50                   | push                eax
            //   89b574ffffff         | mov                 dword ptr [ebp - 0x8c], esi
            //   899d44ffffff         | mov                 dword ptr [ebp - 0xbc], ebx
            //   e8????????           |                     

        $sequence_1 = { 2385d4feffff 8d93f36f2e68 8985d8feffff 8bc6 2385b8feffff 0985d8feffff 8bc7 }
            // n = 7, score = 200
            //   2385d4feffff         | and                 eax, dword ptr [ebp - 0x12c]
            //   8d93f36f2e68         | lea                 edx, [ebx + 0x682e6ff3]
            //   8985d8feffff         | mov                 dword ptr [ebp - 0x128], eax
            //   8bc6                 | mov                 eax, esi
            //   2385b8feffff         | and                 eax, dword ptr [ebp - 0x148]
            //   0985d8feffff         | or                  dword ptr [ebp - 0x128], eax
            //   8bc7                 | mov                 eax, edi

        $sequence_2 = { c64418050a 745a 8b048d88ec4300 8a441825 3c0a }
            // n = 5, score = 200
            //   c64418050a           | mov                 byte ptr [eax + ebx + 5], 0xa
            //   745a                 | je                  0x5c
            //   8b048d88ec4300       | mov                 eax, dword ptr [ecx*4 + 0x43ec88]
            //   8a441825             | mov                 al, byte ptr [eax + ebx + 0x25]
            //   3c0a                 | cmp                 al, 0xa

        $sequence_3 = { 8d8534ffffff 50 e8???????? 8d8534ffffff 50 e8???????? 83c430 }
            // n = 7, score = 200
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c430               | add                 esp, 0x30

        $sequence_4 = { 13bd2cfdffff 81c3281e6323 81d7faffbe90 019d14fdffff 11bd38fdffff }
            // n = 5, score = 200
            //   13bd2cfdffff         | adc                 edi, dword ptr [ebp - 0x2d4]
            //   81c3281e6323         | add                 ebx, 0x23631e28
            //   81d7faffbe90         | adc                 edi, 0x90befffa
            //   019d14fdffff         | add                 dword ptr [ebp - 0x2ec], ebx
            //   11bd38fdffff         | adc                 dword ptr [ebp - 0x2c8], edi

        $sequence_5 = { 898508fdffff 8b8514fdffff 33ff 898d2cfdffff 33d2 8b8d38fdffff }
            // n = 6, score = 200
            //   898508fdffff         | mov                 dword ptr [ebp - 0x2f8], eax
            //   8b8514fdffff         | mov                 eax, dword ptr [ebp - 0x2ec]
            //   33ff                 | xor                 edi, edi
            //   898d2cfdffff         | mov                 dword ptr [ebp - 0x2d4], ecx
            //   33d2                 | xor                 edx, edx
            //   8b8d38fdffff         | mov                 ecx, dword ptr [ebp - 0x2c8]

        $sequence_6 = { 0facca08 8975fc c1e908 8850f8 8bce 8bd3 0facca10 }
            // n = 7, score = 200
            //   0facca08             | shrd                edx, ecx, 8
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   c1e908               | shr                 ecx, 8
            //   8850f8               | mov                 byte ptr [eax - 8], dl
            //   8bce                 | mov                 ecx, esi
            //   8bd3                 | mov                 edx, ebx
            //   0facca10             | shrd                edx, ecx, 0x10

        $sequence_7 = { 50 e8???????? 8b4dec 33c8 8b4514 03c1 894dec }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   33c8                 | xor                 ecx, eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   03c1                 | add                 eax, ecx
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx

        $sequence_8 = { 8b8d9cfeffff 898d9cfeffff 8b9594feffff 899590feffff 8b8598feffff 898594feffff 8b8da4feffff }
            // n = 7, score = 200
            //   8b8d9cfeffff         | mov                 ecx, dword ptr [ebp - 0x164]
            //   898d9cfeffff         | mov                 dword ptr [ebp - 0x164], ecx
            //   8b9594feffff         | mov                 edx, dword ptr [ebp - 0x16c]
            //   899590feffff         | mov                 dword ptr [ebp - 0x170], edx
            //   8b8598feffff         | mov                 eax, dword ptr [ebp - 0x168]
            //   898594feffff         | mov                 dword ptr [ebp - 0x16c], eax
            //   8b8da4feffff         | mov                 ecx, dword ptr [ebp - 0x15c]

        $sequence_9 = { 8b8520fdffff 0bd1 319508fdffff 33d2 8b8d18fdffff 8bf1 0fa4c119 }
            // n = 7, score = 200
            //   8b8520fdffff         | mov                 eax, dword ptr [ebp - 0x2e0]
            //   0bd1                 | or                  edx, ecx
            //   319508fdffff         | xor                 dword ptr [ebp - 0x2f8], edx
            //   33d2                 | xor                 edx, edx
            //   8b8d18fdffff         | mov                 ecx, dword ptr [ebp - 0x2e8]
            //   8bf1                 | mov                 esi, ecx
            //   0fa4c119             | shld                ecx, eax, 0x19

    condition:
        7 of them and filesize < 598016
}