rule win_chinoxy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chinoxy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chinoxy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7405 394004 7538 6a3c e8???????? 83c404 89442408 }
            // n = 7, score = 100
            //   7405                 | je                  7
            //   394004               | cmp                 dword ptr [eax + 4], eax
            //   7538                 | jne                 0x3a
            //   6a3c                 | push                0x3c
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   89442408             | mov                 dword ptr [esp + 8], eax

        $sequence_1 = { 897e5c 897e60 897e64 897e68 897e6c 897e70 897c2414 }
            // n = 7, score = 100
            //   897e5c               | mov                 dword ptr [esi + 0x5c], edi
            //   897e60               | mov                 dword ptr [esi + 0x60], edi
            //   897e64               | mov                 dword ptr [esi + 0x64], edi
            //   897e68               | mov                 dword ptr [esi + 0x68], edi
            //   897e6c               | mov                 dword ptr [esi + 0x6c], edi
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   897c2414             | mov                 dword ptr [esp + 0x14], edi

        $sequence_2 = { 52 e8???????? 83c408 85c0 0f84a7000000 8b4f08 6a00 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f84a7000000         | je                  0xad
            //   8b4f08               | mov                 ecx, dword ptr [edi + 8]
            //   6a00                 | push                0

        $sequence_3 = { 8b5918 33eb 33db 33c5 89442414 8be8 8a5c2416 }
            // n = 7, score = 100
            //   8b5918               | mov                 ebx, dword ptr [ecx + 0x18]
            //   33eb                 | xor                 ebp, ebx
            //   33db                 | xor                 ebx, ebx
            //   33c5                 | xor                 eax, ebp
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   8be8                 | mov                 ebp, eax
            //   8a5c2416             | mov                 bl, byte ptr [esp + 0x16]

        $sequence_4 = { 743a 8b431c 8db140800200 85c0 7506 8db15c800200 8bce }
            // n = 7, score = 100
            //   743a                 | je                  0x3c
            //   8b431c               | mov                 eax, dword ptr [ebx + 0x1c]
            //   8db140800200         | lea                 esi, [ecx + 0x28040]
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8
            //   8db15c800200         | lea                 esi, [ecx + 0x2805c]
            //   8bce                 | mov                 ecx, esi

        $sequence_5 = { 3bc6 8b5008 895610 75a7 e9???????? 8b85a0020000 }
            // n = 6, score = 100
            //   3bc6                 | cmp                 eax, esi
            //   8b5008               | mov                 edx, dword ptr [eax + 8]
            //   895610               | mov                 dword ptr [esi + 0x10], edx
            //   75a7                 | jne                 0xffffffa9
            //   e9????????           |                     
            //   8b85a0020000         | mov                 eax, dword ptr [ebp + 0x2a0]

        $sequence_6 = { 8bde c1ef10 c1e310 0bfb 2bc6 33f8 03f1 }
            // n = 7, score = 100
            //   8bde                 | mov                 ebx, esi
            //   c1ef10               | shr                 edi, 0x10
            //   c1e310               | shl                 ebx, 0x10
            //   0bfb                 | or                  edi, ebx
            //   2bc6                 | sub                 eax, esi
            //   33f8                 | xor                 edi, eax
            //   03f1                 | add                 esi, ecx

        $sequence_7 = { b9???????? e8???????? 85ff 740a 83c704 57 ff15???????? }
            // n = 7, score = 100
            //   b9????????           |                     
            //   e8????????           |                     
            //   85ff                 | test                edi, edi
            //   740a                 | je                  0xc
            //   83c704               | add                 edi, 4
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_8 = { 8bf9 c1ee18 c1e708 0bf7 2bd9 33f3 }
            // n = 6, score = 100
            //   8bf9                 | mov                 edi, ecx
            //   c1ee18               | shr                 esi, 0x18
            //   c1e708               | shl                 edi, 8
            //   0bf7                 | or                  esi, edi
            //   2bd9                 | sub                 ebx, ecx
            //   33f3                 | xor                 esi, ebx

        $sequence_9 = { 83f8ff 7409 83c004 3bc6 7602 8bf8 }
            // n = 6, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   7409                 | je                  0xb
            //   83c004               | add                 eax, 4
            //   3bc6                 | cmp                 eax, esi
            //   7602                 | jbe                 4
            //   8bf8                 | mov                 edi, eax

    condition:
        7 of them and filesize < 1138688
}