rule win_chiser_client_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chiser_client."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chiser_client"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48890a 48894a08 488d4808 e8???????? 488d05a9e30200 488903 488bc3 }
            // n = 7, score = 100
            //   48890a               | dec                 eax
            //   48894a08             | mov                 edi, ecx
            //   488d4808             | dec                 eax
            //   e8????????           |                     
            //   488d05a9e30200       | mov                 dword ptr [esp + 0x40], ecx
            //   488903               | xorps               xmm0, xmm0
            //   488bc3               | movdqu              xmmword ptr [ebp], xmm0

        $sequence_1 = { 480f40c1 488bc8 e8???????? 488bc8 49890424 }
            // n = 5, score = 100
            //   480f40c1             | inc                 ecx
            //   488bc8               | push                edi
            //   e8????????           |                     
            //   488bc8               | dec                 eax
            //   49890424             | sub                 esp, 0x40

        $sequence_2 = { 0f1f440000 418d40fc 460fb61408 418d40fd 460fb61c08 }
            // n = 5, score = 100
            //   0f1f440000           | dec                 eax
            //   418d40fc             | lea                 ecx, [esp + 0xe0]
            //   460fb61408           | dec                 esp
            //   418d40fd             | lea                 eax, [0x3c956]
            //   460fb61c08           | mov                 dword ptr [ebx + 0x80], 0x630065

        $sequence_3 = { c744245865007800 c744245c2e006800 c744246074006d00 c74424646c000000 4c89742430 bf01000000 897c2428 }
            // n = 7, score = 100
            //   c744245865007800     | dec                 eax
            //   c744245c2e006800     | mov                 dword ptr [ecx + 8], eax
            //   c744246074006d00     | dec                 eax
            //   c74424646c000000     | mov                 dword ptr [ecx + 0x10], eax
            //   4c89742430           | dec                 eax
            //   bf01000000           | lea                 eax, [0x285bf]
            //   897c2428             | dec                 eax

        $sequence_4 = { 498b0e 4c8d4110 488d5108 e8???????? 90 488bcb e8???????? }
            // n = 7, score = 100
            //   498b0e               | lea                 ecx, [esp + 0x68]
            //   4c8d4110             | dec                 eax
            //   488d5108             | lea                 ecx, [esp + 0x58]
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488bcb               | lea                 edx, [0x24e17]
            //   e8????????           |                     

        $sequence_5 = { 41b904000000 0f1f440000 b904000000 6666660f1f840000000000 410fb60414 }
            // n = 5, score = 100
            //   41b904000000         | jmp                 0x43
            //   0f1f440000           | dec                 ecx
            //   b904000000           | cmp                 esi, esi
            //   6666660f1f840000000000     | ja    0xcc
            //   410fb60414           | dec                 eax

        $sequence_6 = { 488bc5 0f1f00 48ffc0 66833c4100 75f6 83c008 4863f8 }
            // n = 7, score = 100
            //   488bc5               | inc                 esp
            //   0f1f00               | mov                 ecx, esi
            //   48ffc0               | dec                 esp
            //   66833c4100           | lea                 eax, [esp + 0x50]
            //   75f6                 | mov                 edx, 0x2000
            //   83c008               | dec                 ecx
            //   4863f8               | mov                 ecx, dword ptr [esi]

        $sequence_7 = { 48636908 488bf1 4c8b7118 b802000000 }
            // n = 4, score = 100
            //   48636908             | dec                 esp
            //   488bf1               | lea                 eax, [0x764]
            //   4c8b7118             | jmp                 0x6e
            //   b802000000           | cmp                 eax, 0x300003

        $sequence_8 = { 48894320 488d1511f5ffff e8???????? eb09 488bcb ff15???????? 408ac5 }
            // n = 7, score = 100
            //   48894320             | jg                  0x3e7
            //   488d1511f5ffff       | movzx               eax, word ptr [edi + edx*2]
            //   e8????????           |                     
            //   eb09                 | sub                 ax, 0x30
            //   488bcb               | cmp                 ax, 9
            //   ff15????????         |                     
            //   408ac5               | jbe                 0x3b3

        $sequence_9 = { 81ca00000780 85c0 0f4ed0 e8???????? 488d1584aa0100 488d4c2440 }
            // n = 6, score = 100
            //   81ca00000780         | jmp                 0x3c
            //   85c0                 | and                 dl, 0x3f
            //   0f4ed0               | inc                 ebp
            //   e8????????           |                     
            //   488d1584aa0100       | mov                 ebx, ecx
            //   488d4c2440           | inc                 edx

    condition:
        7 of them and filesize < 714752
}