rule win_chrgetpdsi_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chrgetpdsi_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chrgetpdsi_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488dbc2428010000 488d742408 660f1f840000000000 0f1f4000 48896c24f0 488d6c24f0 e8???????? }
            // n = 7, score = 500
            //   488dbc2428010000     | je                  0x15ac
            //   488d742408           | dec                 eax
            //   660f1f840000000000     | lea    ecx, [0x2385f6]
            //   0f1f4000             | xor                 ecx, ecx
            //   48896c24f0           | mov                 edx, 8
            //   488d6c24f0           | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { e8???????? 84c0 0f8489010000 488b4c2458 488d7101 488b7c2478 0f1f440000 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   84c0                 | mov                 ebx, dword ptr [esp + 0x38]
            //   0f8489010000         | dec                 eax
            //   488b4c2458           | lea                 ecx, [0x27f6fe]
            //   488d7101             | mov                 edi, 6
            //   488b7c2478           | nop                 dword ptr [eax]
            //   0f1f440000           | test                byte ptr [eax], al

        $sequence_2 = { 48898c24b0000000 4889442468 48895c2460 488d3dd9b32500 be27000000 e8???????? 488b542468 }
            // n = 7, score = 500
            //   48898c24b0000000     | mov                 esi, dword ptr [esi]
            //   4889442468           | mov                 eax, dword ptr [esp]
            //   48895c2460           | dec                 eax
            //   488d3dd9b32500       | mov                 dword ptr [esp + 0x30], eax
            //   be27000000           | dec                 eax
            //   e8????????           |                     
            //   488b542468           | lea                 eax, [0x2db543]

        $sequence_3 = { 89d8 e8???????? 4889442458 48895c2448 488d05e3a61c00 0f1f00 e8???????? }
            // n = 7, score = 500
            //   89d8                 | mov                 ecx, dword ptr [esp + 0x948]
            //   e8????????           |                     
            //   4889442458           | dec                 eax
            //   48895c2448           | mov                 dword ptr [eax + 0x18], ecx
            //   488d05e3a61c00       | dec                 eax
            //   0f1f00               | mov                 dword ptr [esp + 0xa48], ecx
            //   e8????????           |                     

        $sequence_4 = { 90 90 488d05e41e4200 e8???????? 90 488b4c2420 488b542418 }
            // n = 7, score = 500
            //   90                   | mov                 ebx, dword ptr [esp + 0x148]
            //   90                   | dec                 eax
            //   488d05e41e4200       | mov                 dword ptr [esp + 0x138], edx
            //   e8????????           |                     
            //   90                   | dec                 esp
            //   488b4c2420           | lea                 eax, [0x1ac0ea]
            //   488b542418           | dec                 esp

        $sequence_5 = { b909000000 488bbc2408060000 488bb42410060000 4c8d0575882700 41b91a000000 e8???????? 0f1f4000 }
            // n = 7, score = 500
            //   b909000000           | dec                 eax
            //   488bbc2408060000     | mov                 dword ptr [eax + 8], edx
            //   488bb42410060000     | jne                 0xf48
            //   4c8d0575882700       | dec                 eax
            //   41b91a000000         | mov                 dword ptr [esp + 0x98], ebx
            //   e8????????           |                     
            //   0f1f4000             | dec                 eax

        $sequence_6 = { 31c0 31c9 31d2 31db e9???????? 4889d9 4889c3 }
            // n = 7, score = 500
            //   31c0                 | mov                 ecx, ebp
            //   31c9                 | dec                 eax
            //   31d2                 | mov                 eax, dword ptr [esp + 0x88]
            //   31db                 | dec                 eax
            //   e9????????           |                     
            //   4889d9               | test                eax, eax
            //   4889c3               | je                  0xffffffbf

        $sequence_7 = { 48c740100f000000 488d0dca832500 48894808 833d????????00 7509 488905???????? eb0c }
            // n = 7, score = 500
            //   48c740100f000000     | dec                 eax
            //   488d0dca832500       | lea                 eax, [0x13604d]
            //   48894808             | dec                 eax
            //   833d????????00       |                     
            //   7509                 | mov                 ecx, dword ptr [esp + 0x20]
            //   488905????????       |                     
            //   eb0c                 | dec                 eax

        $sequence_8 = { 4c8b842410010000 0f1f4000 e9???????? 4c8b842410010000 4d85c0 7e24 498d48ff }
            // n = 7, score = 500
            //   4c8b842410010000     | cmp                 dword ptr [esi + 0x30], 0
            //   0f1f4000             | jne                 0x4be
            //   e9????????           |                     
            //   4c8b842410010000     | dec                 eax
            //   4d85c0               | mov                 ebx, dword ptr [esp + 0xe0]
            //   7e24                 | jmp                 0x51f
            //   498d48ff             | dec                 esp

        $sequence_9 = { 4c89442478 0f1f00 4883fa01 7546 488d0573ca1a00 bb01000000 4889d9 }
            // n = 7, score = 500
            //   4c89442478           | lea                 ebx, [0x26f4b8]
            //   0f1f00               | inc                 esp
            //   4883fa01             | movzx               ecx, byte ptr [esp + 0x180]
            //   7546                 | inc                 ebp
            //   488d0573ca1a00       | test                cl, cl
            //   bb01000000           | mov                 ebx, 0
            //   4889d9               | mov                 esi, 0

    condition:
        7 of them and filesize < 10027008
}