rule win_cinobi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cinobi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cinobi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c9 c3 55 8bec 51 e8???????? 58 }
            // n = 7, score = 200
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   e8????????           |                     
            //   58                   | pop                 eax

        $sequence_1 = { 660fbe404b 668985a0fdffff 8b45f8 660fbe4005 668985a2fdffff 8b45f8 660fbe4005 }
            // n = 7, score = 100
            //   660fbe404b           | movsx               ax, byte ptr [eax + 0x4b]
            //   668985a0fdffff       | mov                 word ptr [ebp - 0x260], ax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   660fbe4005           | movsx               ax, byte ptr [eax + 5]
            //   668985a2fdffff       | mov                 word ptr [ebp - 0x25e], ax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   660fbe4005           | movsx               ax, byte ptr [eax + 5]

        $sequence_2 = { 55 8bec 83ec44 53 e8???????? }
            // n = 5, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec44               | sub                 esp, 0x44
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_3 = { 8845ce c645cf00 8b45c0 8a4031 }
            // n = 4, score = 100
            //   8845ce               | mov                 byte ptr [ebp - 0x32], al
            //   c645cf00             | mov                 byte ptr [ebp - 0x31], 0
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]
            //   8a4031               | mov                 al, byte ptr [eax + 0x31]

        $sequence_4 = { 6805100000 56 8b75f0 56 ff93f7000000 }
            // n = 5, score = 100
            //   6805100000           | push                0x1005
            //   56                   | push                esi
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   56                   | push                esi
            //   ff93f7000000         | call                dword ptr [ebx + 0xf7]

        $sequence_5 = { 8365dc00 8945e0 8d45fc 8945e4 8d45f4 }
            // n = 5, score = 100
            //   8365dc00             | and                 dword ptr [ebp - 0x24], 0
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_6 = { 50 51 ff93eb000000 8b4df4 e8???????? 8bf8 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ff93eb000000         | call                dword ptr [ebx + 0xeb]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_7 = { 57 8b7dd0 894dfc 3bcb 7504 33c0 eb2c }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8b7dd0               | mov                 edi, dword ptr [ebp - 0x30]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   3bcb                 | cmp                 ecx, ebx
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb2c                 | jmp                 0x2e

        $sequence_8 = { 8a4d0c 8808 ebe5 c9 c3 }
            // n = 5, score = 100
            //   8a4d0c               | mov                 cl, byte ptr [ebp + 0xc]
            //   8808                 | mov                 byte ptr [eax], cl
            //   ebe5                 | jmp                 0xffffffe7
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_9 = { 8845fb 8d45a4 50 ff7508 e8???????? 59 }
            // n = 6, score = 100
            //   8845fb               | mov                 byte ptr [ebp - 5], al
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_10 = { 8b45f4 ff90db000000 8945ec 837decff 7513 }
            // n = 5, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   ff90db000000         | call                dword ptr [eax + 0xdb]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   837decff             | cmp                 dword ptr [ebp - 0x14], -1
            //   7513                 | jne                 0x15

        $sequence_11 = { 8b4510 8945ec 8b45e4 8b4dfc 8b0481 034508 }
            // n = 6, score = 100
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b0481               | mov                 eax, dword ptr [ecx + eax*4]
            //   034508               | add                 eax, dword ptr [ebp + 8]

        $sequence_12 = { 837de000 0f85ac000000 6a02 8d87c0120000 50 }
            // n = 5, score = 100
            //   837de000             | cmp                 dword ptr [ebp - 0x20], 0
            //   0f85ac000000         | jne                 0xb2
            //   6a02                 | push                2
            //   8d87c0120000         | lea                 eax, [edi + 0x12c0]
            //   50                   | push                eax

        $sequence_13 = { 8a5832 885dd1 8a5834 885dd2 }
            // n = 4, score = 100
            //   8a5832               | mov                 bl, byte ptr [eax + 0x32]
            //   885dd1               | mov                 byte ptr [ebp - 0x2f], bl
            //   8a5834               | mov                 bl, byte ptr [eax + 0x34]
            //   885dd2               | mov                 byte ptr [ebp - 0x2e], bl

        $sequence_14 = { 837de8ff 7507 32c0 e9???????? 6a00 ff75e8 8b45f4 }
            // n = 7, score = 100
            //   837de8ff             | cmp                 dword ptr [ebp - 0x18], -1
            //   7507                 | jne                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   6a00                 | push                0
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 32768
}