rule win_citadel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.citadel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.citadel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb0e 6800800000 53 57 }
            // n = 4, score = 5100
            //   eb0e                 | jmp                 0x10
            //   6800800000           | push                0x8000
            //   53                   | push                ebx
            //   57                   | push                edi

        $sequence_1 = { 03f7 6a0d 5f e8???????? }
            // n = 4, score = 5000
            //   03f7                 | add                 esi, edi
            //   6a0d                 | push                0xd
            //   5f                   | pop                 edi
            //   e8????????           |                     

        $sequence_2 = { 3d00002003 7715 8b4d08 890e }
            // n = 4, score = 5000
            //   3d00002003           | cmp                 eax, 0x3200000
            //   7715                 | ja                  0x17
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   890e                 | mov                 dword ptr [esi], ecx

        $sequence_3 = { 50 57 e8???????? 33db 3c01 }
            // n = 5, score = 5000
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   3c01                 | cmp                 al, 1

        $sequence_4 = { 41 66395802 7405 83c002 }
            // n = 4, score = 5000
            //   41                   | inc                 ecx
            //   66395802             | cmp                 word ptr [eax + 2], bx
            //   7405                 | je                  7
            //   83c002               | add                 eax, 2

        $sequence_5 = { a1???????? 57 e8???????? 8945fc 3bc3 }
            // n = 5, score = 5000
            //   a1????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   3bc3                 | cmp                 eax, ebx

        $sequence_6 = { ff15???????? 85c0 0f8566010000 57 57 57 }
            // n = 6, score = 5000
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8566010000         | jne                 0x16c
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi

        $sequence_7 = { 33c9 663918 7507 41 }
            // n = 4, score = 5000
            //   33c9                 | xor                 ecx, ecx
            //   663918               | cmp                 word ptr [eax], bx
            //   7507                 | jne                 9
            //   41                   | inc                 ecx

        $sequence_8 = { eb81 d0e9 3aca 73fa 0fb6c9 8b04c8 ebae }
            // n = 7, score = 3900
            //   eb81                 | jmp                 0xffffff83
            //   d0e9                 | shr                 cl, 1
            //   3aca                 | cmp                 cl, dl
            //   73fa                 | jae                 0xfffffffc
            //   0fb6c9               | movzx               ecx, cl
            //   8b04c8               | mov                 eax, dword ptr [eax + ecx*8]
            //   ebae                 | jmp                 0xffffffb0

        $sequence_9 = { 8b5004 0310 8d7101 3bf2 }
            // n = 4, score = 3900
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   0310                 | add                 edx, dword ptr [eax]
            //   8d7101               | lea                 esi, [ecx + 1]
            //   3bf2                 | cmp                 esi, edx

        $sequence_10 = { 6685c0 7432 66ff460e 6639460e 7228 }
            // n = 5, score = 3900
            //   6685c0               | test                ax, ax
            //   7432                 | je                  0x34
            //   66ff460e             | inc                 word ptr [esi + 0xe]
            //   6639460e             | cmp                 word ptr [esi + 0xe], ax
            //   7228                 | jb                  0x2a

        $sequence_11 = { 33c0 85c0 7409 3255fd }
            // n = 4, score = 3900
            //   33c0                 | xor                 eax, eax
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   3255fd               | xor                 dl, byte ptr [ebp - 3]

        $sequence_12 = { 6685c0 7432 66ff460c 6639460c }
            // n = 4, score = 3900
            //   6685c0               | test                ax, ax
            //   7432                 | je                  0x34
            //   66ff460c             | inc                 word ptr [esi + 0xc]
            //   6639460c             | cmp                 word ptr [esi + 0xc], ax

        $sequence_13 = { 5b b001 eb30 d0e8 }
            // n = 4, score = 3900
            //   5b                   | pop                 ebx
            //   b001                 | mov                 al, 1
            //   eb30                 | jmp                 0x32
            //   d0e8                 | shr                 al, 1

        $sequence_14 = { 85c0 740b 8a5604 8a4e01 ffd0 884601 33c0 }
            // n = 7, score = 3900
            //   85c0                 | test                eax, eax
            //   740b                 | je                  0xd
            //   8a5604               | mov                 dl, byte ptr [esi + 4]
            //   8a4e01               | mov                 cl, byte ptr [esi + 1]
            //   ffd0                 | call                eax
            //   884601               | mov                 byte ptr [esi + 1], al
            //   33c0                 | xor                 eax, eax

        $sequence_15 = { ffd0 8807 fe45ff 8a45ff 3a06 72c4 0fb7460a }
            // n = 7, score = 3900
            //   ffd0                 | call                eax
            //   8807                 | mov                 byte ptr [edi], al
            //   fe45ff               | inc                 byte ptr [ebp - 1]
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]
            //   3a06                 | cmp                 al, byte ptr [esi]
            //   72c4                 | jb                  0xffffffc6
            //   0fb7460a             | movzx               eax, word ptr [esi + 0xa]

    condition:
        7 of them and filesize < 1236992
}