rule win_clambling_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.clambling."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.clambling"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bc6 746f 488d8424a8010000 448d4612 488d8c24a0010000 }
            // n = 5, score = 300
            //   3bc6                 | je                  0xc03
            //   746f                 | mov                 eax, ebx
            //   488d8424a8010000     | dec                 eax
            //   448d4612             | mov                 ebx, dword ptr [esp + 0x30]
            //   488d8c24a0010000     | je                  0xc0e

        $sequence_1 = { 44896c2428 895c2420 e8???????? e9???????? ff15???????? 3bc6 }
            // n = 6, score = 300
            //   44896c2428           | mov                 ebx, 0xd
            //   895c2420             | movzx               eax, cx
            //   e8????????           |                     
            //   e9????????           |                     
            //   ff15????????         |                     
            //   3bc6                 | dec                 ecx

        $sequence_2 = { 440fb75c2440 66453bdd 7f0b 0fb7442442 66413bc7 }
            // n = 5, score = 300
            //   440fb75c2440         | lea                 edx, [0x197a4]
            //   66453bdd             | dec                 eax
            //   7f0b                 | lea                 ecx, [esp + 0x80]
            //   0fb7442442           | mov                 dword ptr [esp + 0x20], edi
            //   66413bc7             | mov                 dword ptr [esp + 0x28], ecx

        $sequence_3 = { 7507 66893d???????? 488b0d???????? 488d542430 ff15???????? 448b442430 33d2 }
            // n = 7, score = 300
            //   7507                 | lea                 edx, [0x1c91c]
            //   66893d????????       |                     
            //   488b0d????????       |                     
            //   488d542430           | dec                 eax
            //   ff15????????         |                     
            //   448b442430           | mov                 ecx, esi
            //   33d2                 | cmp                 eax, -1

        $sequence_4 = { 7412 48ffc3 4883c010 4881fb00040000 }
            // n = 4, score = 300
            //   7412                 | inc                 ebp
            //   48ffc3               | xor                 ecx, ecx
            //   4883c010             | inc                 ebp
            //   4881fb00040000       | xor                 eax, eax

        $sequence_5 = { ffd0 483bdf 7409 488bcb ff15???????? 33c0 488b5c2438 }
            // n = 7, score = 300
            //   ffd0                 | mov                 ecx, esi
            //   483bdf               | mov                 eax, edi
            //   7409                 | dec                 eax
            //   488bcb               | mov                 ebx, dword ptr [esp + 0xa0]
            //   ff15????????         |                     
            //   33c0                 | cmova               ecx, edx
            //   488b5c2438           | dec                 ecx

        $sequence_6 = { 4c8d442470 8d5601 4889442420 ff15???????? }
            // n = 4, score = 300
            //   4c8d442470           | inc                 esp
            //   8d5601               | mov                 eax, dword ptr [edi + 0x14c]
            //   4889442420           | dec                 eax
            //   ff15????????         |                     

        $sequence_7 = { 488b542470 488b8c24a8010000 ff15???????? 8907 eb08 ff15???????? }
            // n = 6, score = 300
            //   488b542470           | xor                 ecx, ecx
            //   488b8c24a8010000     | dec                 esp
            //   ff15????????         |                     
            //   8907                 | lea                 eax, [esp + 0x440]
            //   eb08                 | jne                 0x4e6
            //   ff15????????         |                     

        $sequence_8 = { 8bc3 eb02 33c0 4883c470 415d 5f }
            // n = 6, score = 300
            //   8bc3                 | idiv                ecx
            //   eb02                 | mov                 ebx, eax
            //   33c0                 | xor                 edi, edi
            //   4883c470             | mov                 edx, 0x6000
            //   415d                 | lea                 ecx, [edi + 0x42]
            //   5f                   | mov                 dword ptr [ebx + 8], edi

        $sequence_9 = { 893d???????? ff15???????? 3bc7 7507 66893d???????? }
            // n = 5, score = 300
            //   893d????????         |                     
            //   ff15????????         |                     
            //   3bc7                 | dec                 eax
            //   7507                 | add                 esp, 0x20
            //   66893d????????       |                     

    condition:
        7 of them and filesize < 412672
}