rule win_classfon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.classfon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.classfon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f855c010000 8a442424 8d7c2424 84c0 742a 8b1d???????? a1???????? }
            // n = 7, score = 200
            //   0f855c010000         | jne                 0x162
            //   8a442424             | mov                 al, byte ptr [esp + 0x24]
            //   8d7c2424             | lea                 edi, [esp + 0x24]
            //   84c0                 | test                al, al
            //   742a                 | je                  0x2c
            //   8b1d????????         |                     
            //   a1????????           |                     

        $sequence_1 = { 89be04020000 8b8600020000 3bc7 740e 83f8ff }
            // n = 5, score = 200
            //   89be04020000         | mov                 dword ptr [esi + 0x204], edi
            //   8b8600020000         | mov                 eax, dword ptr [esi + 0x200]
            //   3bc7                 | cmp                 eax, edi
            //   740e                 | je                  0x10
            //   83f8ff               | cmp                 eax, -1

        $sequence_2 = { 57 b985000000 33c0 8d7c240d c644240c00 f3ab 66ab }
            // n = 7, score = 200
            //   57                   | push                edi
            //   b985000000           | mov                 ecx, 0x85
            //   33c0                 | xor                 eax, eax
            //   8d7c240d             | lea                 edi, [esp + 0xd]
            //   c644240c00           | mov                 byte ptr [esp + 0xc], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_3 = { 53 56 8b35???????? 57 8bbc24dc070000 6800010000 8b07 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   57                   | push                edi
            //   8bbc24dc070000       | mov                 edi, dword ptr [esp + 0x7dc]
            //   6800010000           | push                0x100
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_4 = { 7520 8b4350 6a04 6800200000 }
            // n = 4, score = 200
            //   7520                 | jne                 0x22
            //   8b4350               | mov                 eax, dword ptr [ebx + 0x50]
            //   6a04                 | push                4
            //   6800200000           | push                0x2000

        $sequence_5 = { 6a20 68ff010f00 6a00 8bd0 }
            // n = 4, score = 200
            //   6a20                 | push                0x20
            //   68ff010f00           | push                0xf01ff
            //   6a00                 | push                0
            //   8bd0                 | mov                 edx, eax

        $sequence_6 = { 8bf0 3bf5 0f859d010000 8d4c241c 8d542424 51 8b4c2414 }
            // n = 7, score = 200
            //   8bf0                 | mov                 esi, eax
            //   3bf5                 | cmp                 esi, ebp
            //   0f859d010000         | jne                 0x1a3
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   8d542424             | lea                 edx, [esp + 0x24]
            //   51                   | push                ecx
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]

        $sequence_7 = { 683f000f00 6a00 51 52 ff15???????? 8bf0 85f6 }
            // n = 7, score = 200
            //   683f000f00           | push                0xf003f
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_8 = { 6a01 6800000080 57 ff15???????? 8b742418 83f8ff }
            // n = 6, score = 200
            //   6a01                 | push                1
            //   6800000080           | push                0x80000000
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b742418             | mov                 esi, dword ptr [esp + 0x18]
            //   83f8ff               | cmp                 eax, -1

        $sequence_9 = { 8b442418 8d4c2400 c744240000000000 51 68???????? }
            // n = 5, score = 200
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8d4c2400             | lea                 ecx, [esp]
            //   c744240000000000     | mov                 dword ptr [esp], 0
            //   51                   | push                ecx
            //   68????????           |                     

    condition:
        7 of them and filesize < 73728
}