rule win_client_maximus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.client_maximus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.client_maximus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89542404 ff532c 8b5308 83c601 39730c }
            // n = 5, score = 300
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   ff532c               | call                dword ptr [ebx + 0x2c]
            //   8b5308               | mov                 edx, dword ptr [ebx + 8]
            //   83c601               | add                 esi, 1
            //   39730c               | cmp                 dword ptr [ebx + 0xc], esi

        $sequence_1 = { 8b4304 85c0 741d 8b5330 c744240800800000 c744240400000000 890424 }
            // n = 7, score = 300
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   85c0                 | test                eax, eax
            //   741d                 | je                  0x1f
            //   8b5330               | mov                 edx, dword ptr [ebx + 0x30]
            //   c744240800800000     | mov                 dword ptr [esp + 8], 0x8000
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_2 = { 890424 8954240c ff5320 ff15???????? 895c2408 }
            // n = 5, score = 300
            //   890424               | mov                 dword ptr [esp], eax
            //   8954240c             | mov                 dword ptr [esp + 0xc], edx
            //   ff5320               | call                dword ptr [ebx + 0x20]
            //   ff15????????         |                     
            //   895c2408             | mov                 dword ptr [esp + 8], ebx

        $sequence_3 = { c70424???????? ffd0 a1???????? 85c0 7438 }
            // n = 5, score = 300
            //   c70424????????       |                     
            //   ffd0                 | call                eax
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7438                 | je                  0x3a

        $sequence_4 = { e8???????? 8b4304 85c0 741d 8b5330 c744240800800000 c744240400000000 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   85c0                 | test                eax, eax
            //   741d                 | je                  0x1f
            //   8b5330               | mov                 edx, dword ptr [ebx + 0x30]
            //   c744240800800000     | mov                 dword ptr [esp + 8], 0x8000
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0

        $sequence_5 = { 85c0 741d 8b5330 c744240800800000 }
            // n = 4, score = 300
            //   85c0                 | test                eax, eax
            //   741d                 | je                  0x1f
            //   8b5330               | mov                 edx, dword ptr [ebx + 0x30]
            //   c744240800800000     | mov                 dword ptr [esp + 8], 0x8000

        $sequence_6 = { 7410 8b5330 890424 89542404 ff532c 8b5308 }
            // n = 6, score = 300
            //   7410                 | je                  0x12
            //   8b5330               | mov                 edx, dword ptr [ebx + 0x30]
            //   890424               | mov                 dword ptr [esp], eax
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   ff532c               | call                dword ptr [ebx + 0x2c]
            //   8b5308               | mov                 edx, dword ptr [ebx + 8]

        $sequence_7 = { 89c2 85d2 7409 c70424???????? ffd2 8d65f8 }
            // n = 6, score = 300
            //   89c2                 | mov                 edx, eax
            //   85d2                 | test                edx, edx
            //   7409                 | je                  0xb
            //   c70424????????       |                     
            //   ffd2                 | call                edx
            //   8d65f8               | lea                 esp, [ebp - 8]

        $sequence_8 = { 8b4628 85c0 7535 c70424???????? }
            // n = 4, score = 300
            //   8b4628               | mov                 eax, dword ptr [esi + 0x28]
            //   85c0                 | test                eax, eax
            //   7535                 | jne                 0x37
            //   c70424????????       |                     

        $sequence_9 = { 85c0 741d 8b5330 c744240800800000 c744240400000000 890424 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   741d                 | je                  0x1f
            //   8b5330               | mov                 edx, dword ptr [ebx + 0x30]
            //   c744240800800000     | mov                 dword ptr [esp + 8], 0x8000
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   890424               | mov                 dword ptr [esp], eax

    condition:
        7 of them and filesize < 106496
}