rule win_cloudburst_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cloudburst."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cloudburst"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33d3 41891424 4133d3 4189542404 }
            // n = 4, score = 300
            //   33d3                 | cmp                 al, 8
            //   41891424             | je                  0xb7
            //   4133d3               | dec                 eax
            //   4189542404           | lea                 edx, [0x5fb1c]

        $sequence_1 = { 49ffc0 eb39 0fb6c1 43c6041825 }
            // n = 4, score = 300
            //   49ffc0               | mov                 edx, dword ptr [esp + 0x60]
            //   eb39                 | dec                 eax
            //   0fb6c1               | lea                 ecx, [0x64c38]
            //   43c6041825           | dec                 eax

        $sequence_2 = { 4585c0 743e 488b0d???????? 4c8d4c2448 488bd7 }
            // n = 5, score = 300
            //   4585c0               | dec                 eax
            //   743e                 | xor                 ecx, esp
            //   488b0d????????       |                     
            //   4c8d4c2448           | xor                 ecx, ecx
            //   488bd7               | mov                 edx, 0x85f

        $sequence_3 = { 45330c24 45894c2410 4133d1 4189542414 448bc2 4533442408 }
            // n = 6, score = 300
            //   45330c24             | dec                 eax
            //   45894c2410           | mov                 ecx, ebx
            //   4133d1               | dec                 eax
            //   4189542414           | mov                 ebx, dword ptr [ebx]
            //   448bc2               | je                  0x1c
            //   4533442408           | nop                 word ptr [eax + eax]

        $sequence_4 = { 0f8cb0000000 48897c2450 4c89642458 488bfe }
            // n = 4, score = 300
            //   0f8cb0000000         | je                  0x13f
            //   48897c2450           | jne                 0x46b3
            //   4c89642458           | dec                 ebx
            //   488bfe               | arpl                word ptr [edi + ebp*8 + 4], cx

        $sequence_5 = { 4d8bf8 440fb6420c 41c1e108 4c8d35a3e5ffff 41c1e008 c1e708 }
            // n = 6, score = 300
            //   4d8bf8               | inc                 eax
            //   440fb6420c           | cmp                 al, dh
            //   41c1e108             | jne                 0x40f
            //   4c8d35a3e5ffff       | dec                 eax
            //   41c1e008             | or                  eax, 0xffffffff
            //   c1e708               | dec                 ecx

        $sequence_6 = { 418bea 4589542440 33eb 8bc5 }
            // n = 4, score = 300
            //   418bea               | dec                 eax
            //   4589542440           | add                 ebx, edi
            //   33eb                 | inc                 ecx
            //   8bc5                 | movzx               esi, word ptr [esp + 0x12]

        $sequence_7 = { c744245068000000 48894598 c744247004010000 c745a004010000 }
            // n = 4, score = 300
            //   c744245068000000     | dec                 esp
            //   48894598             | mov                 edx, ecx
            //   c744247004010000     | mov                 ebp, edi
            //   c745a004010000       | dec                 ebp

        $sequence_8 = { 418bc6 99 83e20f 03c2 8bc8 83e00f 3bc2 }
            // n = 7, score = 300
            //   418bc6               | nop                 
            //   99                   | dec                 eax
            //   83e20f               | lea                 edx, [esp + 0x40]
            //   03c2                 | dec                 eax
            //   8bc8                 | mov                 ecx, ebx
            //   83e00f               | dec                 eax
            //   3bc2                 | lea                 edx, [0xbb3ef]

        $sequence_9 = { 418b4424fc 418942fc 4183bf0002000001 0f8e3d010000 90 458b4c24e0 41ffc6 }
            // n = 7, score = 300
            //   418b4424fc           | mov                 eax, 0xecfa
            //   418942fc             | mov                 ecx, 0xb
            //   4183bf0002000001     | dec                 esp
            //   0f8e3d010000         | mov                 dword ptr [ebp - 0x21], ebp
            //   90                   | dec                 esp
            //   458b4c24e0           | mov                 dword ptr [ebp + 7], ebp
            //   41ffc6               | dec                 esp

    condition:
        7 of them and filesize < 2363392
}