rule win_cloudwizard_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cloudwizard."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cloudwizard"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4802 668b38 40 40 6685ff }
            // n = 5, score = 100
            //   8d4802               | lea                 ecx, [eax + 2]
            //   668b38               | mov                 di, word ptr [eax]
            //   40                   | inc                 eax
            //   40                   | inc                 eax
            //   6685ff               | test                di, di

        $sequence_1 = { d1f8 51 8d844618060000 50 e8???????? bf???????? 8bc7 }
            // n = 7, score = 100
            //   d1f8                 | sar                 eax, 1
            //   51                   | push                ecx
            //   8d844618060000       | lea                 eax, [esi + eax*2 + 0x618]
            //   50                   | push                eax
            //   e8????????           |                     
            //   bf????????           |                     
            //   8bc7                 | mov                 eax, edi

        $sequence_2 = { 57 50 e8???????? 8d4570 83c40c }
            // n = 5, score = 100
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4570               | lea                 eax, [ebp + 0x70]
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 8bc6 8975ec e8???????? ff750c 8b06 ff7508 8bce }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   e8????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bce                 | mov                 ecx, esi

        $sequence_4 = { 6a5a 58 6a5d 66894544 }
            // n = 4, score = 100
            //   6a5a                 | push                0x5a
            //   58                   | pop                 eax
            //   6a5d                 | push                0x5d
            //   66894544             | mov                 word ptr [ebp + 0x44], ax

        $sequence_5 = { 58 6a44 668945a8 58 6a1b }
            // n = 5, score = 100
            //   58                   | pop                 eax
            //   6a44                 | push                0x44
            //   668945a8             | mov                 word ptr [ebp - 0x58], ax
            //   58                   | pop                 eax
            //   6a1b                 | push                0x1b

        $sequence_6 = { 8986fc010000 897e70 c686c800000043 c6864b01000043 c7466838d54000 }
            // n = 5, score = 100
            //   8986fc010000         | mov                 dword ptr [esi + 0x1fc], eax
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c7466838d54000       | mov                 dword ptr [esi + 0x68], 0x40d538

        $sequence_7 = { 58 6a49 668945e4 58 668945e6 6a5d 58 }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   6a49                 | push                0x49
            //   668945e4             | mov                 word ptr [ebp - 0x1c], ax
            //   58                   | pop                 eax
            //   668945e6             | mov                 word ptr [ebp - 0x1a], ax
            //   6a5d                 | push                0x5d
            //   58                   | pop                 eax

        $sequence_8 = { c645cf4a c645d044 c645d14d c645d27f 885dd3 8d45bc 59 }
            // n = 7, score = 100
            //   c645cf4a             | mov                 byte ptr [ebp - 0x31], 0x4a
            //   c645d044             | mov                 byte ptr [ebp - 0x30], 0x44
            //   c645d14d             | mov                 byte ptr [ebp - 0x2f], 0x4d
            //   c645d27f             | mov                 byte ptr [ebp - 0x2e], 0x7f
            //   885dd3               | mov                 byte ptr [ebp - 0x2d], bl
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   59                   | pop                 ecx

        $sequence_9 = { 8bce ff5010 6a04 33d2 59 }
            // n = 5, score = 100
            //   8bce                 | mov                 ecx, esi
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   6a04                 | push                4
            //   33d2                 | xor                 edx, edx
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 134144
}