rule win_cmsbrute_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cmsbrute."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cmsbrute"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7d1 c1e91f c1e81f 22c1 8bd6 8d4eff c1e91f }
            // n = 7, score = 500
            //   f7d1                 | not                 ecx
            //   c1e91f               | shr                 ecx, 0x1f
            //   c1e81f               | shr                 eax, 0x1f
            //   22c1                 | and                 al, cl
            //   8bd6                 | mov                 edx, esi
            //   8d4eff               | lea                 ecx, [esi - 1]
            //   c1e91f               | shr                 ecx, 0x1f

        $sequence_1 = { ffb57cfeffff 83c01c 50 e8???????? 83c40c 85c0 7d0f }
            // n = 7, score = 500
            //   ffb57cfeffff         | push                dword ptr [ebp - 0x184]
            //   83c01c               | add                 eax, 0x1c
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7d0f                 | jge                 0x11

        $sequence_2 = { e9???????? 8b8780000000 8b7758 81c60c010000 8945d4 3bc3 7505 }
            // n = 7, score = 500
            //   e9????????           |                     
            //   8b8780000000         | mov                 eax, dword ptr [edi + 0x80]
            //   8b7758               | mov                 esi, dword ptr [edi + 0x58]
            //   81c60c010000         | add                 esi, 0x10c
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   3bc3                 | cmp                 eax, ebx
            //   7505                 | jne                 7

        $sequence_3 = { ebad 85f6 7466 8b5d0c 8b03 85c0 7407 }
            // n = 7, score = 500
            //   ebad                 | jmp                 0xffffffaf
            //   85f6                 | test                esi, esi
            //   7466                 | je                  0x68
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9

        $sequence_4 = { ff0e 8b06 85c0 7f3b 7426 68ed010000 bf???????? }
            // n = 7, score = 500
            //   ff0e                 | dec                 dword ptr [esi]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   85c0                 | test                eax, eax
            //   7f3b                 | jg                  0x3d
            //   7426                 | je                  0x28
            //   68ed010000           | push                0x1ed
            //   bf????????           |                     

        $sequence_5 = { f645ff40 7412 8b87c0000000 3b86e0000000 0f85bbfeffff 33c0 40 }
            // n = 7, score = 500
            //   f645ff40             | test                byte ptr [ebp - 1], 0x40
            //   7412                 | je                  0x14
            //   8b87c0000000         | mov                 eax, dword ptr [edi + 0xc0]
            //   3b86e0000000         | cmp                 eax, dword ptr [esi + 0xe0]
            //   0f85bbfeffff         | jne                 0xfffffec1
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_6 = { c3 80f92b 740d 80f92d 7408 84c9 74e4 }
            // n = 7, score = 500
            //   c3                   | ret                 
            //   80f92b               | cmp                 cl, 0x2b
            //   740d                 | je                  0xf
            //   80f92d               | cmp                 cl, 0x2d
            //   7408                 | je                  0xa
            //   84c9                 | test                cl, cl
            //   74e4                 | je                  0xffffffe6

        $sequence_7 = { ffb7f8000000 83c620 ff76e8 c1e003 56 57 50 }
            // n = 7, score = 500
            //   ffb7f8000000         | push                dword ptr [edi + 0xf8]
            //   83c620               | add                 esi, 0x20
            //   ff76e8               | push                dword ptr [esi - 0x18]
            //   c1e003               | shl                 eax, 3
            //   56                   | push                esi
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_8 = { ff4df4 3975dc 7461 c745f001000000 85f6 7456 ff75cc }
            // n = 7, score = 500
            //   ff4df4               | dec                 dword ptr [ebp - 0xc]
            //   3975dc               | cmp                 dword ptr [ebp - 0x24], esi
            //   7461                 | je                  0x63
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   85f6                 | test                esi, esi
            //   7456                 | je                  0x58
            //   ff75cc               | push                dword ptr [ebp - 0x34]

        $sequence_9 = { 8b07 59 8983d8040000 e9???????? ff36 8db334040000 e9???????? }
            // n = 7, score = 500
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   59                   | pop                 ecx
            //   8983d8040000         | mov                 dword ptr [ebx + 0x4d8], eax
            //   e9????????           |                     
            //   ff36                 | push                dword ptr [esi]
            //   8db334040000         | lea                 esi, [ebx + 0x434]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 5275648
}