rule win_cmstar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cmstar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cmstar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 56 bb04010000 57 53 }
            // n = 5, score = 800
            //   53                   | push                ebx
            //   56                   | push                esi
            //   bb04010000           | mov                 ebx, 0x104
            //   57                   | push                edi
            //   53                   | push                ebx

        $sequence_1 = { 8b45e8 ff75e0 ff30 e8???????? 8b4df8 }
            // n = 5, score = 800
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_2 = { 8b4dec c1e802 6a04 52 8d0481 50 e8???????? }
            // n = 7, score = 800
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   c1e802               | shr                 eax, 2
            //   6a04                 | push                4
            //   52                   | push                edx
            //   8d0481               | lea                 eax, [ecx + eax*4]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { ff15???????? 8bc6 e9???????? 6a10 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   e9????????           |                     
            //   6a10                 | push                0x10

        $sequence_4 = { ff15???????? 6a04 e8???????? be00040000 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   6a04                 | push                4
            //   e8????????           |                     
            //   be00040000           | mov                 esi, 0x400

        $sequence_5 = { 8b45d8 836dfc10 ff75fc 8945e0 8b45dc 83c310 8945e4 }
            // n = 7, score = 800
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   836dfc10             | sub                 dword ptr [ebp - 4], 0x10
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   83c310               | add                 ebx, 0x10
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax

        $sequence_6 = { ff15???????? 6a03 58 5f 5e 5b c9 }
            // n = 7, score = 800
            //   ff15????????         |                     
            //   6a03                 | push                3
            //   58                   | pop                 eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_7 = { 85c0 7504 6a03 eb0d 803b4d }
            // n = 5, score = 800
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   6a03                 | push                3
            //   eb0d                 | jmp                 0xf
            //   803b4d               | cmp                 byte ptr [ebx], 0x4d

        $sequence_8 = { 888204420010 83c9ff 33c0 42 f2ae f7d1 49 }
            // n = 7, score = 100
            //   888204420010         | mov                 byte ptr [edx + 0x10004204], al
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   42                   | inc                 edx
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx

        $sequence_9 = { 8bf0 85f6 74b2 817c240cc8000000 741c a1???????? 33f6 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   74b2                 | je                  0xffffffb4
            //   817c240cc8000000     | cmp                 dword ptr [esp + 0xc], 0xc8
            //   741c                 | je                  0x1e
            //   a1????????           |                     
            //   33f6                 | xor                 esi, esi

        $sequence_10 = { 81ec08060000 53 55 56 57 33db b9ff000000 }
            // n = 7, score = 100
            //   81ec08060000         | sub                 esp, 0x608
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   b9ff000000           | mov                 ecx, 0xff

        $sequence_11 = { a1???????? 8b10 52 53 }
            // n = 4, score = 100
            //   a1????????           |                     
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   52                   | push                edx
            //   53                   | push                ebx

        $sequence_12 = { 49 8d7c2418 8bc1 83c9ff 89442410 }
            // n = 5, score = 100
            //   49                   | dec                 ecx
            //   8d7c2418             | lea                 edi, [esp + 0x18]
            //   8bc1                 | mov                 eax, ecx
            //   83c9ff               | or                  ecx, 0xffffffff
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

        $sequence_13 = { a1???????? 85c0 7505 a1???????? 6a00 6a00 6a03 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   a1????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a03                 | push                3

        $sequence_14 = { be01000000 8b4c2420 51 ff15???????? 3beb 7409 55 }
            // n = 7, score = 100
            //   be01000000           | mov                 esi, 1
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   3beb                 | cmp                 ebp, ebx
            //   7409                 | je                  0xb
            //   55                   | push                ebp

        $sequence_15 = { 64890d00000000 81c4c0120000 c3 8b8c24d0120000 33db 3bcb 741c }
            // n = 7, score = 100
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   81c4c0120000         | add                 esp, 0x12c0
            //   c3                   | ret                 
            //   8b8c24d0120000       | mov                 ecx, dword ptr [esp + 0x12d0]
            //   33db                 | xor                 ebx, ebx
            //   3bcb                 | cmp                 ecx, ebx
            //   741c                 | je                  0x1e

    condition:
        7 of them and filesize < 4268032
}