rule win_cohhoc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cohhoc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cohhoc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b9c242c3c0000 66ab aa b9000f0000 33c0 8d7c2420 c745008d000000 }
            // n = 7, score = 300
            //   8b9c242c3c0000       | mov                 ebx, dword ptr [esp + 0x3c2c]
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b9000f0000           | mov                 ecx, 0xf00
            //   33c0                 | xor                 eax, eax
            //   8d7c2420             | lea                 edi, [esp + 0x20]
            //   c745008d000000       | mov                 dword ptr [ebp], 0x8d

        $sequence_1 = { 57 33c0 bf???????? 83c9ff f2ae }
            // n = 5, score = 300
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_2 = { 50 68???????? 68???????? c74424200c000000 895c2424 c744242801000000 ffd6 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   c74424200c000000     | mov                 dword ptr [esp + 0x20], 0xc
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   c744242801000000     | mov                 dword ptr [esp + 0x28], 1
            //   ffd6                 | call                esi

        $sequence_3 = { 8d7c244c 83c9ff 33c0 83c420 f2ae }
            // n = 5, score = 300
            //   8d7c244c             | lea                 edi, [esp + 0x4c]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   83c420               | add                 esp, 0x20
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_4 = { 8b4c2420 8b542424 8b6c2428 8b5c242c 6a08 }
            // n = 5, score = 300
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]
            //   8b6c2428             | mov                 ebp, dword ptr [esp + 0x28]
            //   8b5c242c             | mov                 ebx, dword ptr [esp + 0x2c]
            //   6a08                 | push                8

        $sequence_5 = { be???????? 8d7c2410 33ed f3a5 8b4c245c }
            // n = 5, score = 300
            //   be????????           |                     
            //   8d7c2410             | lea                 edi, [esp + 0x10]
            //   33ed                 | xor                 ebp, ebp
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8b4c245c             | mov                 ecx, dword ptr [esp + 0x5c]

        $sequence_6 = { 8d442410 53 50 68???????? 68???????? c74424200c000000 }
            // n = 6, score = 300
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   c74424200c000000     | mov                 dword ptr [esp + 0x20], 0xc

        $sequence_7 = { 894c2410 89442414 0f85f5feffff b801000000 5f 895d08 }
            // n = 6, score = 300
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   0f85f5feffff         | jne                 0xfffffefb
            //   b801000000           | mov                 eax, 1
            //   5f                   | pop                 edi
            //   895d08               | mov                 dword ptr [ebp + 8], ebx

        $sequence_8 = { 8944242c 0f85b5feffff 8bce e8???????? 668b5702 50 }
            // n = 6, score = 300
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   0f85b5feffff         | jne                 0xfffffebb
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   668b5702             | mov                 dx, word ptr [edi + 2]
            //   50                   | push                eax

        $sequence_9 = { 8b0d???????? 891d???????? 51 c705????????02000000 e8???????? 83c420 }
            // n = 6, score = 300
            //   8b0d????????         |                     
            //   891d????????         |                     
            //   51                   | push                ecx
            //   c705????????02000000     |     
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20

    condition:
        7 of them and filesize < 253952
}