rule win_coinminer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.coinminer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.coinminer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8d24e5ffff 8b0485a05f9a00 f644010440 7409 803a1a 7504 33c0 }
            // n = 7, score = 100
            //   8b8d24e5ffff         | mov                 ecx, dword ptr [ebp - 0x1adc]
            //   8b0485a05f9a00       | mov                 eax, dword ptr [eax*4 + 0x9a5fa0]
            //   f644010440           | test                byte ptr [ecx + eax + 4], 0x40
            //   7409                 | je                  0xb
            //   803a1a               | cmp                 byte ptr [edx], 0x1a
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 8b85f0feffff 85c0 7509 33d2 }
            // n = 4, score = 100
            //   8b85f0feffff         | mov                 eax, dword ptr [ebp - 0x110]
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   33d2                 | xor                 edx, edx

        $sequence_2 = { 83c801 85c0 741d 8d85d4fdffff }
            // n = 4, score = 100
            //   83c801               | or                  eax, 1
            //   85c0                 | test                eax, eax
            //   741d                 | je                  0x1f
            //   8d85d4fdffff         | lea                 eax, [ebp - 0x22c]

        $sequence_3 = { ebcc 5f 5e 33c0 5b 8be5 }
            // n = 6, score = 100
            //   ebcc                 | jmp                 0xffffffce
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_4 = { c7465c60fd8f00 83660800 33ff 47 897e14 }
            // n = 5, score = 100
            //   c7465c60fd8f00       | mov                 dword ptr [esi + 0x5c], 0x8ffd60
            //   83660800             | and                 dword ptr [esi + 8], 0
            //   33ff                 | xor                 edi, edi
            //   47                   | inc                 edi
            //   897e14               | mov                 dword ptr [esi + 0x14], edi

        $sequence_5 = { ff15???????? 6683bc24b002000000 8d8c24b0020000 ba???????? }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   6683bc24b002000000     | cmp    word ptr [esp + 0x2b0], 0
            //   8d8c24b0020000       | lea                 ecx, [esp + 0x2b0]
            //   ba????????           |                     

        $sequence_6 = { 7e58 bc80304a3e 60 4c 1c00 59 6443 }
            // n = 7, score = 100
            //   7e58                 | jle                 0x5a
            //   bc80304a3e           | mov                 esp, 0x3e4a3080
            //   60                   | pushal              
            //   4c                   | dec                 esp
            //   1c00                 | sbb                 al, 0
            //   59                   | pop                 ecx
            //   6443                 | inc                 ebx

        $sequence_7 = { 57 6868060000 0f57c0 894c2440 8d8424ec000000 c744242400004000 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   6868060000           | push                0x668
            //   0f57c0               | xorps               xmm0, xmm0
            //   894c2440             | mov                 dword ptr [esp + 0x40], ecx
            //   8d8424ec000000       | lea                 eax, [esp + 0xec]
            //   c744242400004000     | mov                 dword ptr [esp + 0x24], 0x400000

        $sequence_8 = { c3 8b04c50c509000 5d c3 55 8bec 8b4508 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8b04c50c509000       | mov                 eax, dword ptr [eax*8 + 0x90500c]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_9 = { 8304240d cb 8d85b0fdffff 8945fc 85c0 745d 8b4df0 }
            // n = 7, score = 100
            //   8304240d             | add                 dword ptr [esp], 0xd
            //   cb                   | retf                
            //   8d85b0fdffff         | lea                 eax, [ebp - 0x250]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax
            //   745d                 | je                  0x5f
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

    condition:
        7 of them and filesize < 1523712
}