rule win_colony_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.colony."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.colony"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740f 0301 eb0b a801 }
            // n = 4, score = 600
            //   740f                 | imul                eax, edx, 0x30674eef
            //   0301                 | imul                edx, edx, 0x48f0000
            //   eb0b                 | sub                 ecx, eax
            //   a801                 | shr                 ecx, 0x10

        $sequence_1 = { 32c0 8be5 5d c3 807d0800 56 57 }
            // n = 7, score = 600
            //   32c0                 | jg                  0x1cf
            //   8be5                 | je                  0x1b3
            //   5d                   | cmp                 eax, 0x2809
            //   c3                   | jg                  0x102
            //   807d0800             | je                  0xe2
            //   56                   | jg                  0x1cf
            //   57                   | je                  0x1b3

        $sequence_2 = { 8b4224 2b4220 660f6ec0 f30fe6c0 }
            // n = 4, score = 600
            //   8b4224               | imul                eax, edx, 0x30674eef
            //   2b4220               | imul                edx, edx, 0x48f0000
            //   660f6ec0             | sub                 ecx, eax
            //   f30fe6c0             | shr                 ecx, 0x10

        $sequence_3 = { 8b421c 2b4218 660f6ec0 f30fe6c0 }
            // n = 4, score = 600
            //   8b421c               | mov                 eax, dword ptr [eax]
            //   2b4218               | cmp                 eax, 1
            //   660f6ec0             | jle                 0x61
            //   f30fe6c0             | test                dword ptr [edx + 4], 0x800

        $sequence_4 = { 8a4203 8841fe 8a4202 8841ff 8b02 c1e808 8801 }
            // n = 7, score = 600
            //   8a4203               | add                 eax, dword ptr [ecx]
            //   8841fe               | jmp                 0xd
            //   8a4202               | test                al, 1
            //   8841ff               | je                  9
            //   8b02                 | mov                 ecx, 1
            //   c1e808               | jmp                 0xc
            //   8801                 | xor                 ecx, ecx

        $sequence_5 = { 334f14 8b45f4 894dfc 8bca c1e910 81e1ff000000 c1e808 }
            // n = 7, score = 600
            //   334f14               | jne                 0xc2
            //   8b45f4               | movq                qword ptr [esi], xmm0
            //   894dfc               | mov                 byte ptr [esi + 8], al
            //   8bca                 | mov                 eax, 0x3c0a
            //   c1e910               | pop                 esi
            //   81e1ff000000         | jne                 0xc3
            //   c1e808               | cmp                 byte ptr [ebp - 0x26], 1

        $sequence_6 = { 69d200008f04 2bc8 c1e910 69c161a4f778 2bd0 }
            // n = 5, score = 600
            //   69d200008f04         | mov                 al, cl
            //   2bc8                 | sub                 al, 0x61
            //   c1e910               | cmp                 al, 5
            //   69c161a4f778         | xor                 al, al
            //   2bd0                 | mov                 esp, ebp

        $sequence_7 = { 7407 b901000000 eb0a 33c9 803f01 0f95c1 33c0 }
            // n = 7, score = 600
            //   7407                 | lea                 eax, [ebp - 0x20c]
            //   b901000000           | push                eax
            //   eb0a                 | imul                edx, edx, 0x48f0000
            //   33c9                 | sub                 ecx, eax
            //   803f01               | shr                 ecx, 0x10
            //   0f95c1               | imul                eax, ecx, 0x78f7a461
            //   33c0                 | sub                 edx, eax

        $sequence_8 = { 0fbed9 83eb30 eb13 8ac1 }
            // n = 4, score = 600
            //   0fbed9               | mov                 dword ptr [ebp - 4], ecx
            //   83eb30               | mov                 ecx, edx
            //   eb13                 | shr                 ecx, 0x10
            //   8ac1                 | and                 ecx, 0xff

        $sequence_9 = { 0f85bd000000 807dda01 751f 66a1???????? }
            // n = 4, score = 600
            //   0f85bd000000         | inc                 ebx
            //   807dda01             | mov                 eax, dword ptr [ecx + eax*4 + 0x6035]
            //   751f                 | dec                 esp
            //   66a1????????         |                     

        $sequence_10 = { 0f85bc000000 f30f7e05???????? 660fd606 a0???????? }
            // n = 4, score = 600
            //   0f85bc000000         | mov                 edx, edi
            //   f30f7e05????????     |                     
            //   660fd606             | dec                 eax
            //   a0????????           |                     

        $sequence_11 = { 0f855b010000 8d7830 c7403c00000000 8d4838 eb0d 8d7824 }
            // n = 6, score = 600
            //   0f855b010000         | dec                 eax
            //   8d7830               | lea                 ecx, [0x7b68]
            //   c7403c00000000       | xor                 edx, edx
            //   8d4838               | inc                 ecx
            //   eb0d                 | mov                 eax, 0x800
            //   8d7824               | dec                 eax

        $sequence_12 = { 8b00 83f801 7e5c f7420400080000 }
            // n = 4, score = 600
            //   8b00                 | cmp                 byte ptr [edi], 1
            //   83f801               | setne               cl
            //   7e5c                 | xor                 eax, eax
            //   f7420400080000       | je                  0x11

        $sequence_13 = { 0f8fc9010000 0f84ad010000 3d09280000 0f8ff1000000 }
            // n = 4, score = 600
            //   0f8fc9010000         | mov                 eax, dword ptr [ebp - 0xc]
            //   0f84ad010000         | mov                 dword ptr [ebp - 4], ecx
            //   3d09280000           | mov                 ecx, edx
            //   0f8ff1000000         | shr                 ecx, 0x10

        $sequence_14 = { 8b4214 2b4210 660f6ec0 f30fe6c0 }
            // n = 4, score = 600
            //   8b4214               | mov                 al, byte ptr [edx + 3]
            //   2b4210               | mov                 byte ptr [ecx - 2], al
            //   660f6ec0             | mov                 al, byte ptr [edx + 2]
            //   f30fe6c0             | mov                 byte ptr [ecx - 1], al

        $sequence_15 = { 0101 0101 0202 0202 0200 0102 0202 }
            // n = 7, score = 600
            //   0101                 | jne                 0x21
            //   0101                 | jne                 0xc3
            //   0202                 | cmp                 byte ptr [ebp - 0x26], 1
            //   0202                 | jne                 0x21
            //   0200                 | jne                 0xc3
            //   0102                 | cmp                 byte ptr [ebp - 0x26], 1
            //   0202                 | jne                 0x21

        $sequence_16 = { 483305???????? 488bcb 488905???????? ff15???????? 488d15a9980000 }
            // n = 5, score = 100
            //   483305????????       |                     
            //   488bcb               | mov                 ecx, 0x1e
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d15a9980000       | mov                 ecx, 0xff

        $sequence_17 = { e9???????? 4c8d357e0c0100 488b0d???????? eb7b 4c8d35660c0100 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   4c8d357e0c0100       | lea                 esi, [0xfc90]
            //   488b0d????????       |                     
            //   eb7b                 | dec                 eax
            //   4c8d35660c0100       | mov                 ecx, ebx

        $sequence_18 = { 48393d???????? 448bf0 0f85f8000000 488d0d687b0000 33d2 41b800080000 }
            // n = 6, score = 100
            //   48393d????????       |                     
            //   448bf0               | dec                 eax
            //   0f85f8000000         | lea                 edx, [0x98a9]
            //   488d0d687b0000       | dec                 eax
            //   33d2                 | mov                 ecx, eax
            //   41b800080000         | dec                 eax

        $sequence_19 = { e8???????? 488d15a3a50000 488d0d94a50000 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   488d15a3a50000       | dec                 eax
            //   488d0d94a50000       | lea                 edx, [0xa5a3]
            //   e8????????           |                     

        $sequence_20 = { 488bd7 488bcf 48c1f905 83e21f 4c8d05f8c70000 498b0cc8 486bd258 }
            // n = 7, score = 100
            //   488bd7               | lea                 edx, [0x7b14]
            //   488bcf               | dec                 eax
            //   48c1f905             | mov                 ecx, ebx
            //   83e21f               | dec                 esp
            //   4c8d05f8c70000       | lea                 esi, [0x10c7e]
            //   498b0cc8             | jmp                 0x87
            //   486bd258             | dec                 esp

        $sequence_21 = { 7519 4c8d05f3900000 8bd7 498bce }
            // n = 4, score = 100
            //   7519                 | dec                 eax
            //   4c8d05f3900000       | lea                 ecx, [0xa594]
            //   8bd7                 | jne                 0x1b
            //   498bce               | dec                 esp

        $sequence_22 = { b91e000000 e8???????? b9ff000000 e8???????? 4803db 4c8d3590fc0000 }
            // n = 6, score = 100
            //   b91e000000           | lea                 eax, [0x90f3]
            //   e8????????           |                     
            //   b9ff000000           | mov                 edx, edi
            //   e8????????           |                     
            //   4803db               | dec                 ecx
            //   4c8d3590fc0000       | mov                 ecx, esi

        $sequence_23 = { 488bc8 ff15???????? 488d15147b0000 488bcb 488905???????? }
            // n = 5, score = 100
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488d15147b0000       | add                 ebx, ebx
            //   488bcb               | dec                 esp
            //   488905????????       |                     

    condition:
        7 of them and filesize < 7599104
}