rule win_combos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.combos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.combos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab c1e604 aa 8d9e50120110 803b00 8bcb }
            // n = 6, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   c1e604               | shl                 esi, 4
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d9e50120110         | lea                 ebx, [esi + 0x10011250]
            //   803b00               | cmp                 byte ptr [ebx], 0
            //   8bcb                 | mov                 ecx, ebx

        $sequence_1 = { 899ddcfeffff 899dd4feffff 895dfc 8b4508 }
            // n = 4, score = 100
            //   899ddcfeffff         | mov                 dword ptr [ebp - 0x124], ebx
            //   899dd4feffff         | mov                 dword ptr [ebp - 0x12c], ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_2 = { e8???????? 8b35???????? 83c408 6a0a ffd6 a1???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c408               | add                 esp, 8
            //   6a0a                 | push                0xa
            //   ffd6                 | call                esi
            //   a1????????           |                     

        $sequence_3 = { 81ec00020000 57 b93f000000 33c0 8d7c2405 }
            // n = 5, score = 100
            //   81ec00020000         | sub                 esp, 0x200
            //   57                   | push                edi
            //   b93f000000           | mov                 ecx, 0x3f
            //   33c0                 | xor                 eax, eax
            //   8d7c2405             | lea                 edi, [esp + 5]

        $sequence_4 = { 0bc5 33c1 8b848600ffffff 0bc7 5f 5e }
            // n = 6, score = 100
            //   0bc5                 | or                  eax, ebp
            //   33c1                 | xor                 eax, ecx
            //   8b848600ffffff       | mov                 eax, dword ptr [esi + eax*4 - 0x100]
            //   0bc7                 | or                  eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_5 = { 6800010000 51 57 ffd6 8d542408 }
            // n = 5, score = 100
            //   6800010000           | push                0x100
            //   51                   | push                ecx
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   8d542408             | lea                 edx, [esp + 8]

        $sequence_6 = { 33ff 89bdccfeffff 89bdc8feffff c785a0feffff24000000 c785a4feffff03000100 c785a8feffff08000000 8d85c8feffff }
            // n = 7, score = 100
            //   33ff                 | xor                 edi, edi
            //   89bdccfeffff         | mov                 dword ptr [ebp - 0x134], edi
            //   89bdc8feffff         | mov                 dword ptr [ebp - 0x138], edi
            //   c785a0feffff24000000     | mov    dword ptr [ebp - 0x160], 0x24
            //   c785a4feffff03000100     | mov    dword ptr [ebp - 0x15c], 0x10003
            //   c785a8feffff08000000     | mov    dword ptr [ebp - 0x158], 8
            //   8d85c8feffff         | lea                 eax, [ebp - 0x138]

        $sequence_7 = { 6a00 56 8b74243c 56 ffd3 83c428 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   56                   | push                esi
            //   8b74243c             | mov                 esi, dword ptr [esp + 0x3c]
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   83c428               | add                 esp, 0x28

        $sequence_8 = { 80c120 888800190110 eb1f 83f861 }
            // n = 4, score = 100
            //   80c120               | add                 cl, 0x20
            //   888800190110         | mov                 byte ptr [eax + 0x10011900], cl
            //   eb1f                 | jmp                 0x21
            //   83f861               | cmp                 eax, 0x61

        $sequence_9 = { 33c0 89442418 8944241c 85db }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   85db                 | test                ebx, ebx

    condition:
        7 of them and filesize < 163840
}